/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.data.trait.TraitBuilder;
import net.silentchaos512.gear.traits.AttributeTrait;
import net.silentchaos512.gear.util.DataResource;

public class AttributeTraitBuilder
extends TraitBuilder {
    private final Map<String, List<AttributeTrait.ModifierData>> modifiers = new LinkedHashMap<String, List<AttributeTrait.ModifierData>>();

    public AttributeTraitBuilder(DataResource<ITrait> trait, int maxLevel) {
        this(trait.getId(), maxLevel);
    }

    public AttributeTraitBuilder(ResourceLocation traitId, int maxLevel) {
        super(traitId, maxLevel, AttributeTrait.SERIALIZER);
    }

    public AttributeTraitBuilder addModifier(GearType gearType, EquipmentSlotType slot, IAttribute attribute, AttributeModifier.Operation operation, float ... values) {
        this.modifiers.computeIfAbsent(AttributeTraitBuilder.makeKey(gearType, slot), str -> new ArrayList()).add(AttributeTrait.ModifierData.of(attribute, operation, values));
        return this;
    }

    public AttributeTraitBuilder addModifiersEitherHand(GearType gearType, IAttribute attribute, AttributeModifier.Operation operation, float ... values) {
        this.addModifier(gearType, EquipmentSlotType.MAINHAND, attribute, operation, values);
        this.addModifier(gearType, EquipmentSlotType.OFFHAND, attribute, operation, values);
        return this;
    }

    private static String makeKey(GearType gearType, EquipmentSlotType slot) {
        return gearType.getName() + "/" + slot.func_188450_d();
    }

    @Override
    public JsonObject serialize() {
        if (this.modifiers.isEmpty()) {
            throw new IllegalStateException("Attribute trait '" + this.traitId + "' has no modifiers");
        }
        JsonObject json = super.serialize();
        JsonObject modsJson = new JsonObject();
        this.modifiers.forEach((key, mods) -> {
            JsonArray array = new JsonArray();
            mods.forEach(e -> array.add((JsonElement)e.serialize()));
            modsJson.add(key, (JsonElement)array);
        });
        json.add("attribute_modifiers", (JsonElement)modsJson);
        return json;
    }
}

