/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.traits.SimpleTrait;
import net.silentchaos512.gear.util.DataResource;

public class TraitBuilder {
    final ResourceLocation traitId;
    private final int maxLevel;
    private final ResourceLocation type;
    private ITextComponent name;
    private ITextComponent description;
    private final Collection<ResourceLocation> cancelsList = new ArrayList<ResourceLocation>();
    private final Collection<ResourceLocation> overridesList = new ArrayList<ResourceLocation>();
    private Consumer<JsonObject> extraData = json -> {};

    public TraitBuilder(DataResource<ITrait> trait, int maxLevel, ITraitSerializer<?> serializer) {
        this(trait.getId(), maxLevel, serializer);
    }

    public TraitBuilder(ResourceLocation traitId, int maxLevel, ITraitSerializer<?> serializer) {
        this.traitId = traitId;
        this.type = serializer.getName();
        this.maxLevel = maxLevel;
        this.name = new TranslationTextComponent(Util.func_200697_a((String)"trait", (ResourceLocation)traitId), new Object[0]);
        this.description = new TranslationTextComponent(Util.func_200697_a((String)"trait", (ResourceLocation)traitId) + ".desc", new Object[0]);
    }

    public static TraitBuilder simple(DataResource<ITrait> trait, int maxLevel) {
        return TraitBuilder.simple(trait.getId(), maxLevel);
    }

    public static TraitBuilder simple(ResourceLocation traitId, int maxLevel) {
        return new TraitBuilder(traitId, maxLevel, SimpleTrait.SERIALIZER);
    }

    public TraitBuilder setName(ITextComponent text) {
        this.name = text;
        return this;
    }

    public TraitBuilder setDescription(ITextComponent text) {
        this.description = text;
        return this;
    }

    public TraitBuilder cancelsWith(DataResource<ITrait> trait) {
        return this.cancelsWith(trait.getId());
    }

    public TraitBuilder cancelsWith(ResourceLocation trait) {
        this.cancelsList.add(trait);
        return this;
    }

    public TraitBuilder overridesTrait(DataResource<ITrait> trait) {
        return this.overridesTrait(trait.getId());
    }

    public TraitBuilder overridesTrait(ResourceLocation trait) {
        this.overridesList.add(trait);
        return this;
    }

    public TraitBuilder extraData(Consumer<JsonObject> consumer) {
        this.extraData = consumer;
        return this;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type.toString());
        json.addProperty("max_level", (Number)this.maxLevel);
        json.add("name", ITextComponent.Serializer.func_200528_b((ITextComponent)this.name));
        json.add("description", ITextComponent.Serializer.func_200528_b((ITextComponent)this.description));
        if (!this.cancelsList.isEmpty()) {
            JsonArray cancelsArray = new JsonArray();
            this.cancelsList.forEach(id -> cancelsArray.add(id.toString()));
            json.add("cancels_with", (JsonElement)cancelsArray);
        }
        if (!this.overridesList.isEmpty()) {
            JsonArray overridesArray = new JsonArray();
            this.overridesList.forEach(id -> overridesArray.add(id.toString()));
            json.add("overrides", (JsonElement)overridesArray);
        }
        this.extraData.accept(json);
        return json;
    }
}

