/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.trait;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.data.trait.AttributeTraitBuilder;
import net.silentchaos512.gear.data.trait.BlockPlacerTraitBuilder;
import net.silentchaos512.gear.data.trait.DurabilityTraitBuilder;
import net.silentchaos512.gear.data.trait.EnchantmentTraitBuilder;
import net.silentchaos512.gear.data.trait.PotionTraitBuilder;
import net.silentchaos512.gear.data.trait.StatModifierTraitBuilder;
import net.silentchaos512.gear.data.trait.SynergyTraitBuilder;
import net.silentchaos512.gear.data.trait.TraitBuilder;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.traits.DamageTypeTrait;
import net.silentchaos512.gear.util.Const;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraitsProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public TraitsProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public String func_200397_b() {
        return "Silent Gear - Traits";
    }

    protected Collection<TraitBuilder> getTraits() {
        ArrayList<TraitBuilder> ret = new ArrayList<TraitBuilder>();
        ret.add(TraitBuilder.simple(Const.Traits.ANCIENT, 5));
        ret.add(TraitBuilder.simple(Const.Traits.CHILLED, 5));
        ret.add(TraitBuilder.simple(Const.Traits.CONFETTI, 5));
        ret.add(TraitBuilder.simple(Const.Traits.FLAMMABLE, 1));
        ret.add(TraitBuilder.simple(Const.Traits.INDESTRUCTIBLE, 1));
        ret.add(TraitBuilder.simple(Const.Traits.JABBERWOCKY, 1));
        ret.add(TraitBuilder.simple(Const.Traits.LUSTROUS, 5));
        ret.add(TraitBuilder.simple(Const.Traits.MAGMATIC, 1));
        ret.add(TraitBuilder.simple(Const.Traits.MAGNETIC, 5));
        ret.add(TraitBuilder.simple(Const.Traits.MULTI_BREAK, 5));
        ret.add(TraitBuilder.simple(Const.Traits.SPOON, 1));
        ret.add(new SynergyTraitBuilder(Const.Traits.CRUDE, 5, -0.04f).cancelsWith(Const.Traits.RUSTIC).cancelsWith(Const.Traits.SYNERGISTIC));
        ret.add(new SynergyTraitBuilder(Const.Traits.RUSTIC, 5, 0.05f).setRange(0.749f, 1.001f).cancelsWith(Const.Traits.SYNERGISTIC));
        ret.add(new SynergyTraitBuilder(Const.Traits.SYNERGISTIC, 5, 0.04f).setRangeMin(1.0f).cancelsWith(Const.Traits.CRUDE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.BRITTLE, 5, 1, 0.1f).cancelsWith(Const.Traits.MALLEABLE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.FLEXIBLE, 5, -1, 0.05f).cancelsWith(Const.Traits.BRITTLE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.MALLEABLE, 5, -1, 0.1f).cancelsWith(Const.Traits.BRITTLE));
        ret.add(new AttributeTraitBuilder(Const.Traits.CURSED, 7).addModifiersEitherHand(GearType.ALL, SharedMonsterAttributes.field_188792_h, AttributeModifier.Operation.ADDITION, -0.5f, -1.0f, -1.5f, -2.0f, -3.0f, -4.0f, -5.0f).cancelsWith(Const.Traits.LUCKY));
        ret.add(new AttributeTraitBuilder(Const.Traits.LUCKY, 7).addModifiersEitherHand(GearType.ALL, SharedMonsterAttributes.field_188792_h, AttributeModifier.Operation.ADDITION, 0.5f, 1.0f, 1.5f, 2.0f, 3.0f, 4.0f, 5.0f).cancelsWith(Const.Traits.CURSED));
        int maxLevel = 5;
        float[] values = new float[maxLevel];
        for (int i = 0; i < maxLevel; ++i) {
            values[i] = -0.15f * (float)(i + 1);
        }
        ret.add(new AttributeTraitBuilder(Const.Traits.MOONWALKER, maxLevel).addModifier(GearType.BOOTS, EquipmentSlotType.FEET, LivingEntity.ENTITY_GRAVITY, AttributeModifier.Operation.MULTIPLY_BASE, values));
        ret.add(new EnchantmentTraitBuilder(Const.Traits.FIERY, 2).addEnchantments(GearType.MELEE_WEAPON, Enchantments.field_77334_n, 1, 2).addEnchantments(GearType.RANGED_WEAPON, Enchantments.field_185311_w, 1));
        ret.add(new EnchantmentTraitBuilder(Const.Traits.SILKY, 1).addEnchantments(GearType.HARVEST_TOOL, Enchantments.field_185306_r, 1));
        ret.add(new PotionTraitBuilder(Const.Traits.ADAMANT, 5).addEffect(GearType.ARMOR, false, Effects.field_76429_m, 1, 1, 1, 2));
        ret.add(new PotionTraitBuilder(Const.Traits.AQUATIC, 5).addEffect(GearType.ARMOR, true, Effects.field_76427_o, 1));
        ret.add(new PotionTraitBuilder(Const.Traits.FLAME_WARD, 1).addEffect(GearType.ARMOR, true, Effects.field_76426_n, 1).overridesTrait(Const.Traits.FLAMMABLE));
        ret.add(new PotionTraitBuilder(Const.Traits.STELLAR, 5).addEffect(GearType.ARMOR, false, Effects.field_76424_c, 0, 1, 2, 3).addEffect(GearType.ARMOR, false, Effects.field_76430_j, 1, 2, 3, 4));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ACCELERATE, 5).addStatMod(ItemStats.HARVEST_SPEED, 2.0f, true, false).addStatMod(ItemStats.ATTACK_SPEED, 0.01f, true, false).addStatMod(ItemStats.RANGED_SPEED, 0.01f, true, false));
        ret.add(new StatModifierTraitBuilder(Const.Traits.BULKY, 5).addStatMod(ItemStats.ATTACK_SPEED, -0.075f, true, false));
        ret.add(new StatModifierTraitBuilder(Const.Traits.CHIPPING, 5).addStatMod(ItemStats.ARMOR, -0.075f, true, true).addStatMod(ItemStats.HARVEST_SPEED, 0.25f, true, true));
        ret.add(new StatModifierTraitBuilder(Const.Traits.CRUSHING, 5).addStatMod(ItemStats.ARMOR, 0.05f, true, true).addStatMod(ItemStats.MELEE_DAMAGE, -0.1667f, true, true));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ERODED, 5).addStatMod(ItemStats.MELEE_DAMAGE, -0.15f, true, true).addStatMod(ItemStats.HARVEST_SPEED, 0.15f, true, true).cancelsWith(Const.Traits.JAGGED));
        ret.add(new StatModifierTraitBuilder(Const.Traits.HARD, 5).addStatMod(ItemStats.HARVEST_SPEED, 0.05f, true, true).addStatMod(ItemStats.RANGED_DAMAGE, -0.1f, true, true).cancelsWith(Const.Traits.SOFT));
        ret.add(new StatModifierTraitBuilder(Const.Traits.JAGGED, 5).addStatMod(ItemStats.MELEE_DAMAGE, 0.1667f, true, true).addStatMod(ItemStats.RANGED_DAMAGE, -0.1667f, true, true).cancelsWith(Const.Traits.ERODED));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ORGANIC, 5).addStatMod(ItemStats.ENCHANTABILITY, 0.1f, true, true).addStatMod(ItemStats.MAGIC_DAMAGE, -0.15f, true, true).cancelsWith(Const.Traits.ERODED));
        ret.add(new StatModifierTraitBuilder(Const.Traits.SOFT, 5).addStatMod(ItemStats.HARVEST_SPEED, -0.15f, true, true).cancelsWith(Const.Traits.HARD));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.RACKER, 1, Blocks.field_150424_aL, 3));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.REFRACTIVE, 1, (Block)ModBlocks.PHANTOM_LIGHT.get(), 5).sound(SoundEvents.field_187638_cR, 0.75f, 0.5f));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.TERMINUS, 1, Blocks.field_150348_b, 3));
        ret.add(new TraitBuilder(Const.Traits.HOLY, 5, DamageTypeTrait.SERIALIZER).extraData(json -> {
            json.addProperty("damage_type", "holy");
            json.addProperty("damage_bonus", (Number)2);
        }));
        return ret;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path outputFolder = this.generator.func_200391_b();
        for (TraitBuilder builder : this.getTraits()) {
            try {
                String jsonStr = GSON.toJson((JsonElement)builder.serialize());
                String hashStr = field_208307_a.hashUnencodedChars((CharSequence)jsonStr).toString();
                Path path = outputFolder.resolve(String.format("data/%s/silentgear_traits/%s.json", builder.traitId.func_110624_b(), builder.traitId.func_110623_a()));
                if (!Objects.equals(cache.func_208323_a(outputFolder), hashStr) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(jsonStr);
                    }
                }
                cache.func_208316_a(path, hashStr);
            }
            catch (IOException ex) {
                LOGGER.error("Could not save traits to {}", (Object)outputFolder, (Object)ex);
            }
        }
    }
}

