/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.utils.EnumUtils;

public class LazyMaterialInstance
implements IMaterialInstance {
    private final ResourceLocation materialId;
    private final MaterialGrade grade;

    public LazyMaterialInstance(ResourceLocation materialId) {
        this(materialId, MaterialGrade.NONE);
    }

    public LazyMaterialInstance(ResourceLocation materialId, MaterialGrade grade) {
        this.materialId = materialId;
        this.grade = grade;
    }

    public static LazyMaterialInstance of(ResourceLocation materialId) {
        return new LazyMaterialInstance(materialId);
    }

    public static LazyMaterialInstance of(ResourceLocation materialId, MaterialGrade grade) {
        return new LazyMaterialInstance(materialId, grade);
    }

    public static LazyMaterialInstance of(DataResource<IMaterial> material) {
        return LazyMaterialInstance.of(material.getId());
    }

    @Override
    public ResourceLocation getMaterialId() {
        return this.materialId;
    }

    @Override
    @Nullable
    public IMaterial getMaterial() {
        return MaterialManager.get(this.materialId);
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public ItemStack getItem() {
        IMaterial material = this.getMaterial();
        return material != null ? MaterialInstance.of(material).getItem() : ItemStack.field_190927_a;
    }

    @Override
    public int getTier(PartType partType) {
        IMaterial material = this.getMaterial();
        return material != null ? material.getTier(partType) : 0;
    }

    @Override
    public float getStat(ItemStat stat, PartType partType, ItemStack gear) {
        IMaterial material = this.getMaterial();
        return material != null ? material.getStat(stat, partType) : 0.0f;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74778_a("ID", this.materialId.toString());
        if (this.grade != MaterialGrade.NONE) {
            nbt.func_74778_a("Grade", this.grade.name());
        }
        return nbt;
    }

    @Override
    public int getColor(PartType partType, ItemStack gear) {
        IMaterial material = this.getMaterial();
        return material != null ? material.getPrimaryColor(gear, partType) : 0xFFFFFF;
    }

    @Override
    public ITextComponent getDisplayName(PartType partType, ItemStack gear) {
        IMaterial material = this.getMaterial();
        return material != null ? material.getDisplayName(partType, gear) : new StringTextComponent("INVALID");
    }

    public static LazyMaterialInstance deserialize(JsonObject json) {
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"material"));
        MaterialGrade grade = (MaterialGrade)EnumUtils.byName((String)JSONUtils.func_151219_a((JsonObject)json, (String)"grade", (String)"NONE"), (Enum)MaterialGrade.NONE);
        return new LazyMaterialInstance(id, grade);
    }

    public static LazyMaterialInstance read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        MaterialGrade grade = (MaterialGrade)buffer.func_179257_a(MaterialGrade.class);
        return new LazyMaterialInstance(id, grade);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.materialId);
        buffer.func_179249_a((Enum)this.grade);
    }
}

