/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetMaterialStatsEvent;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class MaterialInstance
implements IMaterialInstance {
    private static final Map<ResourceLocation, MaterialInstance> QUICK_CACHE = new HashMap<ResourceLocation, MaterialInstance>();
    private final IMaterial material;
    private final MaterialGrade grade;
    private final ItemStack item;

    private MaterialInstance(IMaterial material) {
        this(material, MaterialGrade.NONE, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IMaterial material, MaterialGrade grade) {
        this(material, grade, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IMaterial material, ItemStack craftingItem) {
        this(material, MaterialGrade.NONE, craftingItem);
    }

    private MaterialInstance(IMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        this.material = material;
        this.grade = grade;
        this.item = craftingItem.func_77946_l();
        this.item.func_190920_e(1);
    }

    public static MaterialInstance of(IMaterial material) {
        return QUICK_CACHE.computeIfAbsent(material.getId(), id -> new MaterialInstance(material));
    }

    public static MaterialInstance of(IMaterial material, MaterialGrade grade) {
        return new MaterialInstance(material, grade);
    }

    public static MaterialInstance of(IMaterial material, ItemStack craftingItem) {
        return new MaterialInstance(material, MaterialGrade.fromStack(craftingItem), craftingItem);
    }

    public static MaterialInstance of(IMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        return new MaterialInstance(material, grade, craftingItem);
    }

    @Nullable
    public static MaterialInstance from(ItemStack stack) {
        IMaterial material = MaterialManager.from(stack);
        if (material != null) {
            return MaterialInstance.of(material, stack);
        }
        return null;
    }

    @Override
    public ResourceLocation getMaterialId() {
        return this.material.getId();
    }

    @Override
    @Nonnull
    public IMaterial getMaterial() {
        return this.material;
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public int getTier(PartType partType) {
        return this.material.getTier(partType);
    }

    public Collection<PartType> getPartTypes() {
        return this.material.getPartTypes();
    }

    public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType) {
        return this.getStatModifiers(stat, partType, ItemStack.field_190927_a);
    }

    public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType, ItemStack gear) {
        Collection<StatInstance> mods = this.material.getStatModifiers(stat, partType, gear);
        if (stat.isAffectedByGrades() && this.grade != MaterialGrade.NONE) {
            float bonus = 1.0f + (float)this.grade.bonusPercent / 100.0f;
            return mods.stream().map(m -> new StatInstance(m.getValue() * bonus, m.getOp())).collect(Collectors.toList());
        }
        GetMaterialStatsEvent event = new GetMaterialStatsEvent(this, stat, partType, mods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    @Override
    public float getStat(ItemStat stat, PartType partType, ItemStack gear) {
        return stat.compute(stat.getDefaultValue(), this.getStatModifiers(stat, partType, gear));
    }

    public boolean canRepair(ItemStack gear) {
        return this.material.allowedInPart(PartType.MAIN) && GearData.getTier(gear) <= this.getTier(PartType.MAIN);
    }

    public int getRepairValue(ItemStack gear) {
        if (this.canRepair(gear)) {
            float durability = this.getStat(GearHelper.getDurabilityStat(gear), PartType.MAIN);
            float repairEfficiency = this.getStat(ItemStats.REPAIR_EFFICIENCY, PartType.MAIN);
            float itemRepairModifier = GearHelper.getRepairModifier(gear);
            return Math.round(durability * repairEfficiency * itemRepairModifier) + 1;
        }
        return 0;
    }

    @Nullable
    public static MaterialInstance read(CompoundNBT nbt) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)nbt.func_74779_i("ID"));
        IMaterial material = MaterialManager.get(id);
        if (material == null) {
            return null;
        }
        ItemStack stack = MaterialInstance.readOrGetDefaultItem(material, nbt);
        return MaterialInstance.of(material, stack);
    }

    private static ItemStack readOrGetDefaultItem(IMaterial material, CompoundNBT nbt) {
        ItemStack[] array;
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item"));
        if (stack.func_190926_b() && (array = material.getIngredient(PartType.MAIN).func_193365_a()).length > 0) {
            return array[0].func_77946_l();
        }
        return stack;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74778_a("ID", this.material.getId().toString());
        nbt.func_218657_a("Item", (INBT)this.item.func_77955_b(new CompoundNBT()));
        return nbt;
    }

    @Override
    @Deprecated
    public int getColor(PartType partType, ItemStack gear) {
        return this.material.getPrimaryColor(gear, partType);
    }

    @Override
    public ITextComponent getDisplayName(PartType partType, ItemStack gear) {
        return this.material.getDisplayName(partType, gear);
    }

    public ITextComponent getDisplayNameWithGrade(PartType partType, ItemStack gear) {
        ITextComponent text = this.getDisplayName(partType, gear);
        if (this.grade != MaterialGrade.NONE) {
            text.func_150258_a(" (").func_150257_a(this.grade.getDisplayName()).func_150258_a(")");
        }
        return text;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.material.getId());
        buffer.func_179249_a((Enum)this.grade);
    }

    @Nullable
    public static MaterialInstance readShorthand(String str) {
        if (str.contains("#")) {
            String[] parts = str.split("#");
            ResourceLocation id = SilentGear.getIdWithDefaultNamespace(parts[0]);
            IMaterial material = MaterialManager.get(id);
            if (material != null) {
                MaterialGrade grade = MaterialGrade.fromString(parts[1]);
                return new MaterialInstance(material, grade);
            }
            return null;
        }
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(str);
        IMaterial material = MaterialManager.get(id);
        if (material != null) {
            return new MaterialInstance(material);
        }
        return null;
    }

    public static String writeShorthand(MaterialInstance material) {
        if (material.grade != MaterialGrade.NONE) {
            return material.getMaterialId() + "#" + (Object)((Object)material.grade);
        }
        return material.getMaterialId().toString();
    }
}

