/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.PartMaterial;
import net.silentchaos512.gear.gear.material.SimplePartAdapterMaterial;

public final class MaterialSerializers {
    private static final Map<ResourceLocation, IMaterialSerializer<?>> REGISTRY = new HashMap();
    public static final PartMaterial.Serializer STANDARD = MaterialSerializers.register(new PartMaterial.Serializer());
    public static final SimplePartAdapterMaterial.Serializer SIMPLE_ADAPTER = MaterialSerializers.register(new SimplePartAdapterMaterial.Serializer());

    private MaterialSerializers() {
    }

    public static <S extends IMaterialSerializer<T>, T extends IMaterial> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate gear part serializer " + serializer.getName());
        }
        SilentGear.LOGGER.info(MaterialManager.MARKER, "Registered serializer '{}'", (Object)serializer.getName());
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static IMaterial deserialize(ResourceLocation id, String packName, JsonObject json) {
        ResourceLocation type = SilentGear.getIdWithDefaultNamespace(JSONUtils.func_151219_a((JsonObject)json, (String)"type", (String)STANDARD.getName().toString()));
        IMaterialSerializer serializer = REGISTRY.getOrDefault(type, STANDARD);
        return serializer.deserialize(id, packName, json);
    }

    public static IMaterial read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        IMaterialSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown material serializer: " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends IMaterial> void write(T material, PacketBuffer buffer) {
        buffer.func_192572_a(material.getId());
        buffer.func_192572_a(material.getSerializer().getName());
        IMaterialSerializer<?> serializer = material.getSerializer();
        serializer.write(buffer, material);
    }
}

