/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.util.ModResourceLocation;

@Mod.EventBusSubscriber(modid="silentgear")
public final class LootInjector {
    private LootInjector() {
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        Tables.get(event.getName()).ifPresent(injectorName -> {
            SilentGear.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
            event.getTable().addPool(LootPool.func_216096_a().name("silentgear_injected").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)injectorName)).func_216044_b());
        });
    }

    public static final class Tables {
        private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
        public static final ResourceLocation CHESTS_NETHER_BRIDGE = Tables.inject(LootTables.field_186425_g);

        private Tables() {
        }

        public static Collection<ResourceLocation> getValues() {
            return MAP.values();
        }

        public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
            return Optional.ofNullable(MAP.get(lootTable));
        }

        private static ResourceLocation inject(ResourceLocation lootTable) {
            ModResourceLocation ret = SilentGear.getId("inject/" + lootTable.func_110623_a());
            MAP.put(lootTable, ret);
            return ret;
        }
    }
}

