/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.FlaxPlant;
import net.silentchaos512.gear.block.MetalBlock;
import net.silentchaos512.gear.block.NetherwoodDoor;
import net.silentchaos512.gear.block.NetherwoodFence;
import net.silentchaos512.gear.block.NetherwoodLeaves;
import net.silentchaos512.gear.block.NetherwoodLog;
import net.silentchaos512.gear.block.NetherwoodPlanks;
import net.silentchaos512.gear.block.NetherwoodSapling;
import net.silentchaos512.gear.block.NetherwoodSlab;
import net.silentchaos512.gear.block.NetherwoodStairs;
import net.silentchaos512.gear.block.NetherwoodTrapdoor;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.block.StoneTorch;
import net.silentchaos512.gear.block.StoneTorchWall;
import net.silentchaos512.gear.block.WildFlaxPlant;
import net.silentchaos512.gear.block.craftingstation.CraftingStationBlock;
import net.silentchaos512.gear.block.grader.GraderBlock;
import net.silentchaos512.gear.block.salvager.SalvagerBlock;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.lib.registry.BlockRegistryObject;

public final class ModBlocks {
    public static final BlockRegistryObject<OreBlock> CRIMSON_IRON_ORE = ModBlocks.register("crimson_iron_ore", () -> ModBlocks.getOre(2, SoundType.field_185851_d));
    public static final BlockRegistryObject<OreBlock> AZURE_SILVER_ORE = ModBlocks.register("azure_silver_ore", () -> ModBlocks.getOre(4, SoundType.field_185851_d));
    public static final BlockRegistryObject<MetalBlock> CRIMSON_IRON_BLOCK = ModBlocks.register("crimson_iron_block", ModBlocks::getMetalBlock);
    public static final BlockRegistryObject<MetalBlock> CRIMSON_STEEL_BLOCK = ModBlocks.register("crimson_steel_block", ModBlocks::getMetalBlock);
    public static final BlockRegistryObject<MetalBlock> BLAZE_GOLD_BLOCK = ModBlocks.register("blaze_gold_block", ModBlocks::getMetalBlock);
    public static final BlockRegistryObject<MetalBlock> AZURE_SILVER_BLOCK = ModBlocks.register("azure_silver_block", ModBlocks::getMetalBlock);
    public static final BlockRegistryObject<MetalBlock> AZURE_ELECTRUM_BLOCK = ModBlocks.register("azure_electrum_block", ModBlocks::getMetalBlock);
    public static final BlockRegistryObject<GraderBlock> MATERIAL_GRADER = ModBlocks.register("material_grader", () -> new GraderBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 30.0f)));
    public static final BlockRegistryObject<CraftingStationBlock> CRAFTING_STATION = ModBlocks.register("crafting_station", CraftingStationBlock::new);
    public static final BlockRegistryObject<SalvagerBlock> SALVAGER = ModBlocks.register("salvager", SalvagerBlock::new);
    public static final BlockRegistryObject<FlaxPlant> FLAX_PLANT = ModBlocks.registerNoItem("flax_plant", () -> new FlaxPlant(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200942_a().func_200944_c().func_200947_a(SoundType.field_222472_s)));
    public static final BlockRegistryObject<WildFlaxPlant> WILD_FLAX_PLANT = ModBlocks.registerNoItem("wild_flax_plant", () -> new WildFlaxPlant(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200942_a().func_200944_c().func_200947_a(SoundType.field_222472_s)));
    public static final BlockRegistryObject<StoneTorch> STONE_TORCH = ModBlocks.register("stone_torch", StoneTorch::new, bro -> ModBlocks.getStoneTorchItem());
    public static final BlockRegistryObject<StoneTorchWall> WALL_STONE_TORCH = ModBlocks.registerNoItem("wall_stone_torch", StoneTorchWall::new);
    public static final BlockRegistryObject<NetherwoodLog> NETHERWOOD_LOG = ModBlocks.register("netherwood_log", () -> new NetherwoodLog(false));
    public static final BlockRegistryObject<NetherwoodLog> STRIPPED_NETHERWOOD_LOG = ModBlocks.register("stripped_netherwood_log", () -> new NetherwoodLog(true));
    public static final BlockRegistryObject<NetherwoodPlanks> NETHERWOOD_PLANKS = ModBlocks.register("netherwood_planks", NetherwoodPlanks::new);
    public static final BlockRegistryObject<NetherwoodSlab> NETHERWOOD_SLAB = ModBlocks.register("netherwood_slab", NetherwoodSlab::new);
    public static final BlockRegistryObject<NetherwoodStairs> NETHERWOOD_STAIRS = ModBlocks.register("netherwood_stairs", NetherwoodStairs::new);
    public static final BlockRegistryObject<NetherwoodFence> NETHERWOOD_FENCE = ModBlocks.register("netherwood_fence", () -> new NetherwoodFence(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
    public static final BlockRegistryObject<NetherwoodDoor> NETHERWOOD_DOOR = ModBlocks.register("netherwood_door", () -> new NetherwoodDoor(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final BlockRegistryObject<NetherwoodTrapdoor> NETHERWOOD_TRAPDOOR = ModBlocks.register("netherwood_trapdoor", () -> new NetherwoodTrapdoor(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final BlockRegistryObject<NetherwoodLeaves> NETHERWOOD_LEAVES = ModBlocks.register("netherwood_leaves", NetherwoodLeaves::new);
    public static final BlockRegistryObject<NetherwoodSapling> NETHERWOOD_SAPLING = ModBlocks.register("netherwood_sapling", NetherwoodSapling::new);
    public static final BlockRegistryObject<FlowerPotBlock> POTTED_NETHERWOOD_SAPLING = ModBlocks.registerNoItem("potted_netherwood_sapling", () -> ModBlocks.makePottedPlant(NETHERWOOD_SAPLING));
    public static final BlockRegistryObject<PhantomLight> PHANTOM_LIGHT = ModBlocks.register("phantom_light", PhantomLight::new);

    private ModBlocks() {
    }

    static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderTypes(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)FLAX_PLANT.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)NETHERWOOD_DOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)NETHERWOOD_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)NETHERWOOD_TRAPDOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)POTTED_NETHERWOOD_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)STONE_TORCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)WALL_STONE_TORCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)WILD_FLAX_PLANT.get()), (RenderType)RenderType.func_228643_e_());
    }

    private static OreBlock getOre(int harvestLevel, SoundType soundType) {
        return new OreBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 10.0f).harvestLevel(harvestLevel).harvestTool(ToolType.PICKAXE).func_200947_a(soundType));
    }

    private static MetalBlock getMetalBlock() {
        return new MetalBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 6.0f).func_200947_a(SoundType.field_185852_e));
    }

    private static <T extends Block> BlockRegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return new BlockRegistryObject(Registration.BLOCKS.register(name, block));
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block) {
        return ModBlocks.register(name, block, ModBlocks::defaultItem);
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block, Function<BlockRegistryObject<T>, Supplier<? extends BlockItem>> item) {
        BlockRegistryObject<T> ret = ModBlocks.registerNoItem(name, block);
        Registration.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static <T extends Block> Supplier<BlockItem> defaultItem(BlockRegistryObject<T> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP));
    }

    private static Supplier<BlockItem> getStoneTorchItem() {
        return () -> new WallOrFloorItem((Block)STONE_TORCH.get(), (Block)WALL_STONE_TORCH.get(), new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP));
    }

    private static FlowerPotBlock makePottedPlant(Supplier<? extends Block> flower) {
        FlowerPotBlock potted = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL.delegate.get(), flower, Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f));
        ResourceLocation flowerId = Objects.requireNonNull(flower.get().getRegistryName());
        ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(flowerId, () -> potted);
        return potted;
    }
}

