/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class FragmentItem
extends Item {
    private static final String NBT_MATERIAL = "Material";

    public FragmentItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack create(IMaterial material, int count) {
        ItemStack stack = new ItemStack((IItemProvider)this, count);
        stack.func_196082_o().func_74778_a(NBT_MATERIAL, material.getId().toString());
        return stack;
    }

    @Nullable
    public static IMaterial getMaterial(ItemStack stack) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)stack.func_196082_o().func_74779_i(NBT_MATERIAL));
        return MaterialManager.get(id);
    }

    public static String getModelKey(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_MATERIAL);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IMaterial material = FragmentItem.getMaterial(stack);
        if (material == null) {
            return new TranslationTextComponent(this.func_77667_c(stack) + ".invalid", new Object[0]);
        }
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[]{material.getDisplayName(PartType.MAIN)});
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        items.add((Object)new ItemStack((IItemProvider)this));
        if (SilentGear.isDevBuild()) {
            for (IMaterial material : MaterialManager.getValues()) {
                items.add((Object)this.create(material, 1));
            }
        }
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        IMaterialDisplay model;
        IMaterial material = FragmentItem.getMaterial(stack);
        if (material != null && (model = MaterialDisplayManager.get(material)) != null) {
            return model.getLayerColor(GearType.ALL, PartType.MAIN, 0);
        }
        return 0xFFFFFF;
    }
}

