/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.item.blueprint.AbstractBlueprintItem;
import net.silentchaos512.lib.util.NameUtils;

public class GearBlueprintItem
extends AbstractBlueprintItem {
    private final GearType gearType;
    private Tag<Item> itemTag;

    public GearBlueprintItem(GearType gearType, boolean singleUse, Item.Properties properties) {
        super(properties, singleUse);
        this.gearType = gearType;
    }

    @Override
    public PartType getPartType(ItemStack stack) {
        return PartType.MAIN;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public GearType getGearType(ItemStack stack) {
        return this.gearType;
    }

    @Override
    public Tag<Item> getItemTag() {
        ResourceLocation id;
        if (this.itemTag == null && (id = this.getRegistryName()) != null) {
            this.itemTag = new ItemTags.Wrapper(new ResourceLocation(id.func_110624_b(), "blueprints/" + this.gearType.getName()));
        }
        return this.itemTag;
    }

    @Override
    protected ITextComponent getCraftedName(ItemStack stack) {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return new StringTextComponent("ERROR");
        }
        return new TranslationTextComponent(Util.func_200697_a((String)"item", (ResourceLocation)new ResourceLocation(id.func_110624_b(), this.gearType.getName())), new Object[0]);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        String itemClass = this.gearType.getName();
        if (!this.gearType.matches("armor")) {
            String key = "item." + NameUtils.fromItem((ItemStack)stack).func_110624_b() + ".blueprint." + itemClass + ".desc";
            list.add(new TranslationTextComponent(key, new Object[0]).func_211708_a(TextFormatting.ITALIC));
        }
        if (this.isDisabled()) {
            list.add(new TranslationTextComponent("item.silentgear.blueprint.disabled", new Object[0]).func_211708_a(TextFormatting.DARK_RED));
        } else if (this.singleUse) {
            list.add(new TranslationTextComponent("item.silentgear.blueprint.singleUse", new Object[0]).func_211708_a(TextFormatting.RED));
        } else {
            list.add(new TranslationTextComponent("item.silentgear.blueprint.multiUse", new Object[0]).func_211708_a(TextFormatting.GREEN));
        }
    }
}

