/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.silentchaos512.gear.init.ModContainers;
import net.silentchaos512.gear.item.IContainerItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;

public class BlueprintBookContainer
extends Container {
    final ItemStack item;
    private final IItemHandler itemHandler;
    int bookSlot = -1;

    public BlueprintBookContainer(int id, PlayerInventory playerInventory, PacketBuffer data) {
        this(id, playerInventory, data.func_150791_c());
    }

    BlueprintBookContainer(int id, PlayerInventory playerInventory, ItemStack stack) {
        super((ContainerType)ModContainers.BLUEPRINT_BOOK.get(), id);
        int y;
        this.item = stack;
        final IContainerItem containerItem = (IContainerItem)this.item.func_77973_b();
        this.itemHandler = containerItem.getInventory(this.item);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            int x = 8 + 18 * (i % 9);
            y = 18 + 18 * (i / 9);
            this.func_75146_a((Slot)new SlotItemHandler(this.itemHandler, i, x, y){

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return containerItem.canStore(stack);
                }
            });
        }
        int rowCount = this.itemHandler.getSlots() / 9;
        int yOffset = (rowCount - 4) * 18;
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 103 + y * 18 + yOffset));
            }
        }
        for (int x = 0; x < 9; ++x) {
            Slot slot = this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 161 + yOffset){

                public boolean func_82869_a(PlayerEntity playerIn) {
                    return this.field_75222_d != BlueprintBookContainer.this.bookSlot;
                }
            });
            if (x != playerInventory.field_70461_c || !ItemStack.func_77989_b((ItemStack)playerInventory.func_70448_g(), (ItemStack)this.item)) continue;
            this.bookSlot = slot.field_75222_d;
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = this.func_75139_a(index);
        if (!slot.func_82869_a(playerIn)) {
            return slot.func_75211_c();
        }
        if (index == this.bookSlot || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        int containerSlots = this.itemHandler.getSlots();
        if (index < containerSlots) {
            if (!this.func_75135_a(stack, containerSlots, this.field_75151_b.size(), true)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
        } else if (!this.func_75135_a(stack, 0, containerSlots, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(playerIn, newStack);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId < 0 || slotId > this.field_75151_b.size()) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (!this.canTake(slotId, slot, dragType, player, clickTypeIn)) {
            return slot.func_75211_c();
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        ((IContainerItem)this.item.func_77973_b()).saveInventory(this.item, this.itemHandler);
    }

    public boolean canTake(int slotId, Slot slot, int button, PlayerEntity player, ClickType clickType) {
        if (slotId == this.bookSlot || slotId <= this.itemHandler.getSlots() - 1 && BlueprintBookContainer.isContainerItem(player.field_71071_by.func_70445_o())) {
            return false;
        }
        if (clickType == ClickType.SWAP) {
            int hotbarId = this.itemHandler.getSlots() + 27 + button;
            if (this.bookSlot == hotbarId) {
                return false;
            }
            Slot hotbarSlot = this.func_75139_a(hotbarId);
            if (slotId <= this.itemHandler.getSlots() - 1) {
                return !BlueprintBookContainer.isContainerItem(slot.func_75211_c()) && !BlueprintBookContainer.isContainerItem(hotbarSlot.func_75211_c());
            }
        }
        return true;
    }

    private static boolean isContainerItem(ItemStack stack) {
        return stack.func_77973_b() instanceof BlueprintBookItem;
    }
}

