/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.ToolItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoreSickle
extends ToolItem
implements ICoreTool {
    public static final ToolType TOOL_TYPE = ToolType.get((String)"sickle");
    private static final int DURABILITY_USAGE = 3;
    private static final int BREAK_RANGE = 4;
    private static final int HARVEST_RANGE = 2;
    static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151570_A, (Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151569_G, (Object)Material.field_215712_y, (Object[])new Material[0]);
    private static final Map<Block, BlockState> HARVEST_STATES = new HashMap<Block, BlockState>();

    public static void putHarvestState(Block block, BlockState state) {
        HARVEST_STATES.put(block, state);
    }

    public CoreSickle() {
        super(0.0f, 0.0f, (IItemTier)ItemTier.DIAMOND, (Set)ImmutableSet.of(), GearHelper.getBuilder(TOOL_TYPE));
        GearHelper.addModelTypeProperty(this);
    }

    @Override
    public GearType getGearType() {
        return GearType.SICKLE;
    }

    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == ItemStats.MELEE_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        if (stat == ItemStats.ATTACK_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(-1.8f));
        }
        if (stat == ItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        return Optional.empty();
    }

    private static boolean canRightClickHarvestBlock(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof IPlantable && block instanceof IGrowable;
    }

    private static boolean tryHarvest(ServerWorld world, BlockPos pos, BlockState state, PlayerEntity player, ItemStack sickle, int fortune) {
        Block block = state.func_177230_c();
        IGrowable growable = (IGrowable)block;
        if (!growable.func_176473_a((IBlockReader)world, pos, state, world.field_72995_K)) {
            NonNullList drops = NonNullList.func_191196_a();
            drops.addAll((Collection)Block.func_220077_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, null, (Entity)player, (ItemStack)sickle));
            ForgeEventFactory.fireBlockHarvesting((NonNullList)drops, (World)world, (BlockPos)pos, (BlockState)state, (int)fortune, (float)1.0f, (boolean)false, (PlayerEntity)player);
            boolean foundSeed = false;
            for (ItemStack drop : drops) {
                Item item = drop.func_77973_b();
                if (!foundSeed && item instanceof BlockItem && ((BlockItem)item).func_179223_d() == block) {
                    foundSeed = true;
                    continue;
                }
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            world.func_180501_a(pos, HARVEST_STATES.getOrDefault(block, block.func_176223_P()), 2);
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        ItemStack sickle = context.func_195996_i();
        if (GearHelper.isBroken(sickle) || !(context.func_195991_k() instanceof ServerWorld)) {
            return ActionResultType.PASS;
        }
        ServerWorld world = (ServerWorld)context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a());
        if (!CoreSickle.canRightClickHarvestBlock(state)) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)sickle);
        int harvestCount = 0;
        int radius = 2;
        for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
            for (int x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
                BlockPos target = new BlockPos(x, pos.func_177956_o(), z);
                state = world.func_180495_p(target);
                if (!CoreSickle.canRightClickHarvestBlock(state) || !CoreSickle.tryHarvest(world, target, state, player, sickle, fortune)) continue;
                ++harvestCount;
            }
        }
        if (harvestCount > 0) {
            GearHelper.attemptDamage(sickle, 3, (LivingEntity)player, context.func_221531_n());
            player.func_71020_j(0.02f);
            return ActionResultType.SUCCESS;
        }
        return GearHelper.onItemUse(context);
    }

    public boolean onBlockStartBreak(ItemStack sickle, BlockPos pos, PlayerEntity player) {
        return this.onSickleStartBreak(sickle, pos, player, 4, EFFECTIVE_MATERIALS);
    }

    boolean onSickleStartBreak(ItemStack sickle, BlockPos pos, PlayerEntity player, int range, Set<Material> effectiveMaterials) {
        if (GearHelper.isBroken(sickle)) {
            return false;
        }
        World world = player.field_70170_p;
        BlockState state = world.func_180495_p(pos);
        if (!effectiveMaterials.contains(state.func_185904_a())) {
            return false;
        }
        int blocksBroken = 1;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xPos = x - range; xPos <= x + range; ++xPos) {
            for (int zPos = z - range; zPos <= z + range; ++zPos) {
                BlockPos target = new BlockPos(xPos, y, zPos);
                if (xPos == x && zPos == z || world.func_180495_p(target) != state || !CoreSickle.breakExtraBlock(sickle, world, target, player, effectiveMaterials)) continue;
                ++blocksBroken;
            }
        }
        return super.onBlockStartBreak(sickle, pos, player);
    }

    private static boolean breakExtraBlock(ItemStack sickle, World world, BlockPos pos, PlayerEntity player, Set<Material> effectiveMaterials) {
        boolean canceled;
        if (world.func_175623_d(pos) || !(player instanceof ServerPlayerEntity)) {
            return false;
        }
        ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
        BlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!effectiveMaterials.contains(state.func_185904_a())) {
            return false;
        }
        int xpDropped = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (ServerPlayerEntity)playerMP, (BlockPos)pos);
        boolean bl = canceled = xpDropped == -1;
        if (canceled) {
            return false;
        }
        if (playerMP.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, (PlayerEntity)playerMP, false, state.func_204520_s())) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            if (!world.field_72995_K) {
                playerMP.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
            return true;
        }
        if (!world.field_72995_K) {
            block.func_176208_a(world, pos, state, (PlayerEntity)playerMP);
            if (block.removedByPlayer(state, world, pos, (PlayerEntity)playerMP, true, state.func_204520_s())) {
                block.func_176206_d((IWorld)world, pos, state);
                block.func_180657_a(world, player, pos, state, null, sickle);
                block.func_180637_b(world, pos, xpDropped);
            }
            playerMP.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
        } else {
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            if (block.removedByPlayer(state, world, pos, (PlayerEntity)playerMP, true, state.func_204520_s())) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            sickle.func_179548_a(world, state, pos, (PlayerEntity)playerMP);
        }
        return true;
    }

    @Override
    public int getDamageOnBlockBreak(ItemStack gear, World world, BlockState state, BlockPos pos) {
        return 3;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_150897_b(BlockState state) {
        return state.func_185904_a() == Material.field_151569_G;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return GearHelper.getDestroySpeed(stack, state, EFFECTIVE_MATERIALS);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return GearHelper.getHarvestLevel(stack, tool, blockState, EFFECTIVE_MATERIALS);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.ENCHANTABILITY);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.DURABILITY);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return GearHelper.hitEntity(stack, target, attacker);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    static {
        CoreSickle.putHarvestState(Blocks.field_222434_lW, (BlockState)Blocks.field_222434_lW.func_176223_P().func_206870_a((IProperty)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(1)));
    }
}

