/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonObject;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.traits.SimpleTrait;
import net.silentchaos512.lib.advancements.LibTriggers;
import net.silentchaos512.utils.MathUtils;

public final class DurabilityTrait
extends SimpleTrait {
    public static final ResourceLocation TRIGGER_BRITTLE = SilentGear.getId("brittle_proc");
    public static final ITraitSerializer<DurabilityTrait> SERIALIZER = new SimpleTrait.Serializer<DurabilityTrait>(SilentGear.getId("durability_trait"), DurabilityTrait::new, (trait, json) -> {
        trait.activationChance = JSONUtils.func_151221_a((JsonObject)json, (String)"activation_chance", (float)1.0f);
        trait.effectScale = JSONUtils.func_151208_a((JsonObject)json, (String)"effect_scale", (int)0);
    }, (trait, buffer) -> {
        trait.activationChance = buffer.readFloat();
        trait.effectScale = buffer.readFloat();
    }, (trait, buffer) -> {
        buffer.writeFloat(trait.activationChance);
        buffer.writeFloat(trait.effectScale);
    });
    private float activationChance;
    private float effectScale;

    private DurabilityTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public float onDurabilityDamage(TraitActionContext context, int damageTaken) {
        PlayerEntity player = context.getPlayer();
        if (damageTaken != 0 && this.shouldActivate(context.getTraitLevel())) {
            if (this.effectScale > 0.0f && player instanceof ServerPlayerEntity) {
                LibTriggers.GENERIC_INT.trigger((ServerPlayerEntity)player, TRIGGER_BRITTLE, 1);
            }
            return Math.round((float)damageTaken + this.effectScale);
        }
        return super.onDurabilityDamage(context, damageTaken);
    }

    private boolean shouldActivate(int level) {
        return MathUtils.tryPercentage((double)(this.activationChance * (float)level));
    }

    @Override
    public ITraitSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

