/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits.conditions;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitConditionSerializer;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.util.GearHelper;

public class GearTypeTraitCondition
implements ITraitCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private static final ResourceLocation NAME = SilentGear.getId("gear_type");
    private final String gearType;

    public GearTypeTraitCondition(String gearType) {
        this.gearType = gearType;
    }

    public GearTypeTraitCondition(GearType gearType) {
        this.gearType = gearType.getName();
    }

    @Override
    public ResourceLocation getId() {
        return NAME;
    }

    @Override
    public boolean matches(ItemStack gear, PartDataList parts, ITrait trait) {
        GearType type = GearHelper.getType(gear);
        return type != null && type.matches(this.gearType);
    }

    @Override
    public boolean matches(ItemStack gear, PartType partType, Collection<MaterialInstance> materials, ITrait trait) {
        GearType type = GearHelper.getType(gear);
        return type == null || type.matches(this.gearType);
    }

    public static class Serializer
    implements ITraitConditionSerializer<GearTypeTraitCondition> {
        @Override
        public ResourceLocation getId() {
            return NAME;
        }

        @Override
        public GearTypeTraitCondition deserialize(JsonObject json) {
            return new GearTypeTraitCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"gear_type"));
        }

        @Override
        public void serialize(GearTypeTraitCondition value, JsonObject json) {
            json.addProperty("gear_type", value.gearType);
        }
    }
}

