/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetTraitsEvent;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitFunction;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class TraitHelper {
    private TraitHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static float activateTraits(ItemStack gear, float inputValue, TraitFunction action) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called activateTraits on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return inputValue;
        }
        ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        float value = inputValue;
        for (INBT nbt : tagList) {
            CompoundNBT tagCompound;
            String regName;
            ITrait trait;
            if (!(nbt instanceof CompoundNBT) || (trait = TraitManager.get(regName = (tagCompound = (CompoundNBT)nbt).func_74779_i("Name"))) == null) continue;
            byte level = tagCompound.func_74771_c("Level");
            value = action.apply(trait, level, value);
        }
        return value;
    }

    public static int getTraitLevel(ItemStack gear, DataResource<ITrait> trait) {
        return TraitHelper.getTraitLevel(gear, trait.getId());
    }

    public static int getTraitLevel(ItemStack gear, ITrait trait) {
        return TraitHelper.getTraitLevel(gear, trait.getId());
    }

    public static int getTraitLevel(ItemStack gear, ResourceLocation traitId) {
        if (GearHelper.isGear(gear)) {
            ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
            for (INBT nbt : tagList) {
                CompoundNBT tagCompound;
                String regName;
                if (!(nbt instanceof CompoundNBT) || !(regName = (tagCompound = (CompoundNBT)nbt).func_74779_i("Name")).equals(traitId.toString())) continue;
                return tagCompound.func_74771_c("Level");
            }
        }
        return 0;
    }

    public static boolean hasTrait(ItemStack gear, DataResource<ITrait> trait) {
        return TraitHelper.hasTrait(gear, trait.getId());
    }

    public static boolean hasTrait(ItemStack gear, ITrait trait) {
        return TraitHelper.hasTrait(gear, trait.getId());
    }

    public static boolean hasTrait(ItemStack gear, ResourceLocation traitId) {
        if (GearHelper.isGear(gear)) {
            ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
            for (INBT nbt : tagList) {
                CompoundNBT tagCompound;
                String regName;
                if (!(nbt instanceof CompoundNBT) || !(regName = (tagCompound = (CompoundNBT)nbt).func_74779_i("Name")).equals(traitId.toString())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static int getHighestLevelEitherHand(PlayerEntity player, DataResource<ITrait> trait) {
        return TraitHelper.getHighestLevelEitherHand(player, trait.getId());
    }

    public static int getHighestLevelEitherHand(PlayerEntity player, ResourceLocation traitId) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        return Math.max(TraitHelper.getTraitLevel(main, traitId), TraitHelper.getTraitLevel(off, traitId));
    }

    public static boolean hasTraitEitherHand(PlayerEntity player, DataResource<ITrait> trait) {
        return TraitHelper.hasTraitEitherHand(player, trait.getId());
    }

    public static boolean hasTraitEitherHand(PlayerEntity player, ResourceLocation traitId) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        return TraitHelper.hasTrait(main, traitId) || TraitHelper.hasTrait(off, traitId);
    }

    public static Map<ITrait, Integer> getCachedTraits(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            return ImmutableMap.of();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        for (INBT nbt : tagList) {
            if (!(nbt instanceof CompoundNBT)) continue;
            CompoundNBT tagCompound = (CompoundNBT)nbt;
            String name = tagCompound.func_74779_i("Name");
            ITrait trait = TraitManager.get(name);
            byte level = tagCompound.func_74771_c("Level");
            if (trait == null || level <= 0) continue;
            result.put(trait, Integer.valueOf(level));
        }
        return result;
    }

    public static Map<ITrait, Integer> getTraits(ItemStack gear, PartDataList parts) {
        if (parts.isEmpty() || GearHelper.isBroken(gear)) {
            return ImmutableMap.of();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        for (PartData part : parts) {
            for (PartTraitInstance inst : part.getTraits(gear)) {
                if (!inst.conditionsMatch(parts, gear)) continue;
                ITrait trait = inst.getTrait();
                result.merge(trait, inst.getLevel(), Integer::max);
            }
        }
        ITrait[] keys = result.keySet().toArray(new ITrait[0]);
        TraitHelper.cancelTraits(result, keys);
        MinecraftForge.EVENT_BUS.post((Event)new GetTraitsEvent(gear, parts, result));
        return result;
    }

    public static Map<ITrait, Integer> getTraits(Collection<MaterialInstance> materials, PartType partType, ItemStack gear) {
        ITrait[] keys;
        if (materials.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        HashMap<ITrait, Integer> countMatsWithTrait = new HashMap<ITrait, Integer>();
        for (MaterialInstance material : materials) {
            for (PartTraitInstance inst : material.getMaterial().getTraits(partType, gear)) {
                if (!inst.conditionsMatch(materials, partType, gear)) continue;
                result.merge(inst.getTrait(), inst.getLevel(), Integer::sum);
                countMatsWithTrait.merge(inst.getTrait(), 1, Integer::sum);
            }
        }
        for (ITrait trait : keys = result.keySet().toArray(new ITrait[0])) {
            int matsWithTrait = (Integer)countMatsWithTrait.get(trait);
            float divisor = Math.max((float)materials.size() / 2.0f, (float)matsWithTrait);
            int value = Math.round((float)((Integer)result.get(trait)).intValue() / divisor);
            result.put(trait, MathHelper.func_76125_a((int)value, (int)1, (int)trait.getMaxLevel()));
        }
        TraitHelper.cancelTraits(result, keys);
        return result;
    }

    private static void cancelTraits(Map<ITrait, Integer> mapToModify, ITrait[] keys) {
        block0: for (int i = 0; i < keys.length; ++i) {
            ITrait t1 = keys[i];
            if (!mapToModify.containsKey(t1)) continue;
            for (int j = i + 1; j < keys.length; ++j) {
                int otherLevel;
                ITrait t2 = keys[j];
                if (!mapToModify.containsKey(t2) || !t1.willCancelWith(t2)) continue;
                int level = mapToModify.get(t1);
                int cancelLevel = t1.getCanceledLevel(level, t2, otherLevel = mapToModify.get(t2).intValue());
                if (cancelLevel > 0) {
                    mapToModify.put(t1, cancelLevel);
                    mapToModify.remove(t2);
                    continue;
                }
                if (cancelLevel < 0) {
                    mapToModify.put(t2, -cancelLevel);
                    mapToModify.remove(t1);
                    continue block0;
                }
                mapToModify.remove(t1);
                mapToModify.remove(t2);
                continue block0;
            }
        }
    }

    static void tickTraits(World world, @Nullable PlayerEntity player, ItemStack gear, boolean isEquipped) {
        ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        for (INBT nbt : tagList) {
            CompoundNBT tagCompound;
            String regName;
            ITrait trait;
            if (!(nbt instanceof CompoundNBT) || (trait = TraitManager.get(regName = (tagCompound = (CompoundNBT)nbt).func_74779_i("Name"))) == null) continue;
            byte level = tagCompound.func_74771_c("Level");
            trait.onUpdate(new TraitActionContext(player, level, gear), isEquipped);
        }
    }
}

