/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.TileBase;
import owmii.lib.util.IVariant;
import owmii.lib.util.Ticker;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodBlock;
import owmii.powah.config.Configs;

public class EnergizingRodTile
extends TileBase.EnergyStorage<Tier, EnergizingRodBlock> {
    private BlockPos orbPos = BlockPos.field_177992_a;
    public final Ticker coolDown = new Ticker(15.0);

    public EnergizingRodTile(Tier variant) {
        super(ITiles.ENERGIZING_ROD, (IVariant)variant);
    }

    public EnergizingRodTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.orbPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("OrbPos"));
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_218657_a("OrbPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.orbPos));
        return super.writeSync(compound);
    }

    protected boolean postTicks(World world) {
        TileEntity tileEntity;
        boolean flag = false;
        if (!this.orbPos.equals((Object)BlockPos.field_177992_a) && (tileEntity = world.func_175625_s(this.orbPos)) instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity;
            if (orb.containRecipe() && this.energy.hasEnergy()) {
                this.coolDown.onward();
                flag = true;
            } else if (this.coolDown.getTicks() > 0.0) {
                this.coolDown.back();
                flag = true;
            }
            if (orb.containRecipe() && this.coolDown.ended()) {
                long fill = Math.min((long)this.energy.getEnergyStored(), this.defaultTransfer());
                orb.fillEnergy(fill);
                this.energy.consume(fill);
                flag = true;
            }
        }
        return flag;
    }

    public boolean hasOrb() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.orbPos != BlockPos.field_177992_a && this.field_145850_b.func_175625_s(this.orbPos) instanceof EnergizingOrbTile;
    }

    public BlockPos getOrbPos() {
        return this.orbPos;
    }

    public void setOrbPos(BlockPos orbPos) {
        this.orbPos = orbPos;
        this.sync(2);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int range = (Integer)Configs.ENERGIZING.range.get();
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)range);
    }

    public boolean keepEnergy() {
        return true;
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return side != null && side.equals((Object)this.func_195044_w().func_177229_b((IProperty)AbstractBlock.FACING));
    }
}

