/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.playertransmitter;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.TileBase;
import owmii.lib.compat.curios.CuriosCompat;
import owmii.lib.energy.Energy;
import owmii.lib.util.IVariant;
import owmii.lib.util.Player;
import owmii.lib.util.Stack;
import owmii.lib.util.Text;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.playertransmitter.PlayerTransmitterBlock;
import owmii.powah.item.BindingCardItem;

public class PlayerTransmitterTile
extends TileBase.EnergyStorage<Tier, PlayerTransmitterBlock> {
    public PlayerTransmitterTile(Tier variant) {
        super(ITiles.PLAYER_TRANSMITTER, (IVariant)variant);
        this.inv.add(1);
    }

    public PlayerTransmitterTile() {
        this(Tier.STARTER);
    }

    protected boolean postTicks(World world) {
        if (this.isRemote() || !this.doWorkingTicks(world)) {
            return false;
        }
        if (!this.energy.hasEnergy()) {
            return false;
        }
        long extracted = 0L;
        for (ItemStack stack : this.inv.getStacks()) {
            int received;
            long amount;
            BindingCardItem bindingCard;
            Optional<ServerPlayerEntity> playerEntity;
            if (!(stack.func_77973_b() instanceof BindingCardItem) || !(playerEntity = (bindingCard = (BindingCardItem)stack.func_77973_b()).getPlayer(stack)).isPresent()) continue;
            ServerPlayerEntity player = playerEntity.get();
            if (!bindingCard.isMultiDim(stack) && !player.field_71093_bK.equals(world.field_73011_w.func_186058_p())) continue;
            long charging = ((PlayerTransmitterBlock)this.getBlock()).getChargingSpeed();
            for (ItemStack stack1 : Player.invStacks((PlayerEntity)player)) {
                if (stack1.func_190926_b()) continue;
                amount = Math.min(charging, this.getEnergyStored());
                received = Energy.receive((ItemStack)stack1, (long)amount, (boolean)false);
                extracted += this.extractEnergy(received, false, null);
            }
            for (ItemStack stack1 : CuriosCompat.getAllStacks((PlayerEntity)player)) {
                if (stack1.func_190926_b()) continue;
                amount = Math.min(charging, this.getEnergyStored());
                received = Energy.receive((ItemStack)stack1, (long)amount, (boolean)false);
                extracted += this.extractEnergy(received, false, null);
            }
        }
        return extracted > 0L;
    }

    public void getListedEnergyInfo(List<String> list) {
        super.getListedEnergyInfo(list);
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.charging.speed", (Object[])new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)((PlayerTransmitterBlock)this.getBlock()).getChargingSpeed())}));
    }

    public boolean canInsert(int index, ItemStack stack) {
        return index == 0 && Stack.getTagOrEmpty((ItemStack)stack).func_186855_b("BoundPlayerId");
    }

    public boolean keepEnergy() {
        return true;
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return side != null && side.equals((Object)this.func_195044_w().func_177229_b((IProperty)AbstractBlock.FACING));
    }
}

