/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.AbstractEnergyProviderBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyProviderConfig;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.item.BlockItemBase;
import owmii.lib.util.IVariant;
import owmii.powah.block.Tier;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.config.Configs;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.ReactorContainer;
import owmii.powah.item.ReactorItem;

public class ReactorBlock
extends AbstractEnergyProviderBlock<Tier> {
    public static final BooleanProperty CORE = BooleanProperty.func_177716_a((String)"core");

    public ReactorBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
        this.setStateProps(state -> {
            BlockState cfr_ignored_0 = (BlockState)state.func_206870_a((IProperty)CORE, (Comparable)Boolean.valueOf(false));
        });
    }

    public BlockItemBase getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new ReactorItem(this, properties, group);
    }

    public IEnergyProviderConfig<Tier> getEnergyConfig() {
        return Configs.REACTOR;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((Boolean)state.func_177229_b((IProperty)CORE)).booleanValue()) {
            return new ReactorTile((Tier)this.variant);
        }
        return new ReactorPartTile((Tier)this.variant);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile tile = (ReactorTile)tileentity;
            tile.shuffle();
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return context.func_195999_j() != null ? (BlockState)this.func_176223_P().func_206870_a((IProperty)CORE, (Comparable)Boolean.valueOf(true)) : super.func_196258_a(context);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ReactorPartTile reactor;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile reactor2 = (ReactorTile)tileentity;
            if (reactor2.isBuilt()) {
                boolean interact = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)reactor2.tank);
                if (interact) {
                    reactor2.markDirtyAndSync();
                    return ActionResultType.SUCCESS;
                }
                return super.func_225533_a_(state, world, pos, player, hand, result);
            }
        } else if (tileentity instanceof ReactorPartTile && (reactor = (ReactorPartTile)tileentity).isBuilt() && reactor.core().isPresent()) {
            return ((ReactorBlock)reactor.getBlock()).func_225533_a_(state, world, reactor.getCorePos(), player, hand, result);
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase te, BlockRayTraceResult result) {
        if (te instanceof ReactorTile) {
            return new ReactorContainer(IContainers.REACTOR, id, playerInventory, (ReactorTile)te);
        }
        return null;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile tile = (ReactorTile)tileentity;
            tile.demolish(world);
        } else if (tileentity instanceof ReactorPartTile) {
            ReactorPartTile tile = (ReactorPartTile)tileentity;
            tile.demolish(world);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{CORE});
    }
}

