/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.thermo;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.lib.block.TileBase;
import owmii.lib.util.IVariant;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.thermo.ThermoGenBlock;

public class ThermoGenTile
extends TileBase.EnergyProvider<Tier, ThermoGenBlock> {
    protected final FluidTank tank = new FluidTank(4000){

        public boolean isFluidValid(FluidStack stack) {
            return PowahAPI.COOLANTS.containsKey(stack.getFluid()) && super.isFluidValid(stack);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            ThermoGenTile.this.sync(5);
        }
    };
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public ThermoGenTile(Tier variant) {
        super(ITiles.THERMO_GEN, (IVariant)variant);
    }

    public ThermoGenTile() {
        this(Tier.STARTER);
    }

    public void readStorable(CompoundNBT compound) {
        this.tank.readFromNBT(compound);
        super.readStorable(compound);
    }

    public CompoundNBT writeStorable(CompoundNBT compound) {
        this.tank.writeToNBT(compound);
        return super.writeStorable(compound);
    }

    protected boolean postTicks(World world) {
        FluidStack fluid;
        boolean flag = this.extractFromSides() + this.chargeItems() > 0L;
        this.nextBuff = 0L;
        if (!this.tank.isEmpty() && PowahAPI.COOLANTS.containsKey((fluid = this.tank.getFluid()).getFluid())) {
            int fluidCooling = PowahAPI.getCoolant(fluid.getFluid());
            BlockPos heatPos = this.field_174879_c.func_177977_b();
            BlockState state = world.func_180495_p(heatPos);
            Block block = state.func_177230_c();
            if (PowahAPI.HEAT_SOURCES.containsKey(block)) {
                FlowingFluidBlock fluidBlock;
                int heat = PowahAPI.getHeatSource(block);
                if (block instanceof FlowingFluidBlock && !(fluidBlock = (FlowingFluidBlock)block).func_204507_t(state).func_206889_d()) {
                    int level = (Integer)state.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b);
                    heat = (int)((float)heat / ((float)level + 1.0f));
                }
                this.nextBuff = (int)((double)heat * (fluidCooling == 1 ? 1.0 : Math.max(1.1, (0.1 + (double)Math.abs(fluidCooling)) * 1.1152)) * (double)this.defaultGeneration() / 1000.0);
                this.energy.produce(this.nextBuff);
                if (this.nextBuff > 0L) {
                    flag = true;
                }
                if (world.func_82737_E() % 40L == 0L) {
                    this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        return flag;
    }

    public boolean hasEnergyBuffer() {
        return true;
    }

    public boolean keepEnergy() {
        return true;
    }

    public int getChargingSlots() {
        return 1;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }
}

