/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.book;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import owmii.lib.client.screen.ScreenBase;
import owmii.lib.client.screen.widget.IconButton;
import owmii.powah.book.PowahBook;
import owmii.powah.book.content.BookEntry;
import owmii.powah.book.content.BookIcon;
import owmii.powah.book.content.page.BookPage;

@OnlyIn(value=Dist.CLIENT)
public class BookScreen
extends ScreenBase {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("powah", "textures/gui/book/background.png");
    public static BookScreen instance = new BookScreen();
    public int x;
    public int y;
    public int w = 196;
    public int h = 230;
    @Nullable
    public BookScreen prevScreen;
    public final BookEntry entry;
    public final BookPage page;
    public int curPage;
    private IconButton[] mainButtons = new IconButton[3];
    private IconButton[] catButtons = new IconButton[PowahBook.getMainEntries().size()];
    public ItemStack hoveredStack = ItemStack.field_190927_a;

    public BookScreen(BookEntry entry, int index) {
        super((ITextComponent)new StringTextComponent(""));
        this.entry = entry;
        this.page = entry.get(index);
        this.curPage = index;
    }

    protected BookScreen() {
        this(PowahBook.get(0), 0);
    }

    protected void init() {
        super.init();
        this.x = (this.width - this.w) / 2;
        this.y = (this.height - this.h) / 2;
        List<BookEntry> mainEntries = PowahBook.getMainEntries();
        for (int i = 0; i < mainEntries.size(); ++i) {
            BookEntry entry = mainEntries.get(i);
            int main = i;
            this.catButtons[i] = new IconButton(this.x - 24, this.y + 20 + i * 25, this.entry.getMain() == i ? 30 : 24, 24, 220, 0, 0, GUI_TEXTURE, button -> {
                this.mc.func_147108_a((Screen)new BookScreen(entry.setMain(main), 0));
                this.refreshButtons();
            }, (Screen)this).tooltip(I18n.func_135052_a((String)entry.getTitle(), (Object[])new Object[0]), new Object[0]);
            this.addButton((Widget)this.catButtons[i]);
        }
        this.mainButtons[0] = new IconButton(this.x + this.w + 2, this.y + 32 + 18, 10, 13, 196, 96, 0, GUI_TEXTURE, button -> {
            if (this.prevScreen != null) {
                this.mc.func_147108_a((Screen)this.prevScreen);
            }
            this.refreshButtons();
        }, (Screen)this);
        this.addButton((Widget)this.mainButtons[0]);
        this.mainButtons[1] = new IconButton(this.x + this.w + 2, this.y + this.h - 32, 12, 23, 208, 58, 0, GUI_TEXTURE, button -> {
            this.curPage = Math.min(this.entry.size() - 1, this.curPage + 1);
            this.mc.func_147108_a((Screen)new BookScreen(this.entry, this.curPage).setPrevScreen(this.prevScreen));
            this.refreshButtons();
        }, (Screen)this);
        this.addButton((Widget)this.mainButtons[1]);
        this.mainButtons[2] = new IconButton(this.x - 14, this.y + this.h - 32, 12, 23, 196, 58, 0, GUI_TEXTURE, button -> {
            this.curPage = Math.max(0, this.curPage - 1);
            this.mc.func_147108_a((Screen)new BookScreen(this.entry, this.curPage).setPrevScreen(this.prevScreen));
            this.refreshButtons();
        }, (Screen)this);
        this.addButton((Widget)this.mainButtons[2]);
        this.refreshButtons();
        this.page.init(this);
        instance = this;
    }

    public void refreshButtons() {
        this.mainButtons[0].visible = (!PowahBook.get(0).equals(this.entry) || this.curPage > 0) && this.prevScreen != null;
        int i = this.entry.size();
        this.mainButtons[1].visible = i > 1 && this.curPage < i - 1;
        this.mainButtons[2].visible = i > 1 && this.curPage > 0;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.mc.field_71446_o.func_110577_a(GUI_TEXTURE);
        this.blit(this.x, this.y, 0, 0, this.w, this.h);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)this.x, (double)this.y, (double)0.0);
        this.page.render(this, mouseX, mouseY, partialTicks);
        if (this.entry.size() > 1) {
            String s = "" + (this.curPage + 1) + "/" + this.entry.size();
            this.font.func_211126_b(s, (float)((this.w - this.font.func_78256_a(s)) / 2), (float)(this.h - 16), 3291959);
        }
        RenderSystem.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)this.x, (double)this.y, (double)0.0);
        this.page.postRender(this, mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
        List<BookEntry> mainEntries = PowahBook.getMainEntries();
        for (int i = 0; i < mainEntries.size(); ++i) {
            BookEntry entry = mainEntries.get(i);
            BookIcon icon = entry.getIcon();
            if (icon.getType().equals((Object)BookIcon.Type.ITEM)) {
                RenderSystem.pushMatrix();
                RenderHelper.func_227784_d_();
                this.mc.func_175599_af().func_180450_b(icon.getStack(), this.x - 24 + 5, this.y + 24 + i * 25);
                RenderHelper.func_74518_a();
                RenderSystem.popMatrix();
                continue;
            }
            this.mc.field_71446_o.func_110577_a(icon.getLocation());
            AbstractGui.blit((int)(this.x - 24 + 5), (int)(this.y + 24 + i * 25), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        for (Widget widget : this.buttons) {
            if (!widget.isHovered()) continue;
            widget.renderToolTip(mouseX, mouseY + 20);
            break;
        }
        if (!this.hoveredStack.func_190926_b()) {
            FontRenderer font = this.hoveredStack.func_77973_b().getFontRenderer(this.hoveredStack);
            GuiUtils.preItemToolTip((ItemStack)this.hoveredStack);
            List tooltip = this.getTooltipFromItem(this.hoveredStack);
            this.renderTooltip(tooltip, mouseX, mouseY, font == null ? this.font : font);
            GuiUtils.postItemToolTip();
        }
    }

    public static void open() {
        Minecraft.func_71410_x().func_147108_a((Screen)instance);
    }

    public void open(BookEntry entry, int i) {
        this.mc.func_147108_a((Screen)new BookScreen(entry, i).setPrevScreen(this));
    }

    @Nullable
    public BookScreen getPrevScreen() {
        return this.prevScreen;
    }

    public BookScreen setPrevScreen(@Nullable BookScreen prevGui) {
        this.prevScreen = prevGui;
        return this;
    }

    public boolean keyPressed(int i, int i1, int i2) {
        return super.keyPressed(i, i1, i2);
    }

    public boolean mouseClicked(double x, double y, int code) {
        return super.mouseClicked(x, y, code);
    }

    public boolean mouseScrolled(double x, double y, double code) {
        if (code < 0.0) {
            int prev = this.curPage;
            this.curPage = Math.min(this.entry.size() - 1, this.curPage + 1);
            if (prev != this.curPage) {
                this.mc.func_147108_a((Screen)new BookScreen(this.entry, this.curPage).setPrevScreen(this.prevScreen));
            }
        } else {
            int prev = this.curPage;
            this.curPage = Math.max(0, this.curPage - 1);
            if (prev != this.curPage) {
                this.mc.func_147108_a((Screen)new BookScreen(this.entry, this.curPage).setPrevScreen(this.prevScreen));
            }
        }
        return true;
    }
}

