/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import owmii.lib.config.Config;
import owmii.powah.Powah;
import owmii.powah.api.PowahAPI;
import owmii.powah.config.Configs;

public class ConfigHandler {
    private static final Map<Fluid, Integer> MAGMATIC_FLUIDS = new HashMap<Fluid, Integer>();
    private static final Map<Block, Integer> HEAT_SOURCES = new HashMap<Block, Integer>();
    private static final Map<Fluid, Integer> COOLANT_FLUIDS = new HashMap<Fluid, Integer>();

    public static void post() {
        ConfigHandler.collectCoolantFluids();
        ConfigHandler.collectHeatSources();
        ConfigHandler.collectMagmaticFluids();
    }

    static void collectCoolantFluids() {
        if (((Boolean)Configs.GENERAL.coolantFluidsAPI.get()).booleanValue()) {
            COOLANT_FLUIDS.putAll(PowahAPI.COOLANTS);
        }
        ((List)Configs.GENERAL.coolantFluids.get()).forEach(s -> {
            block11: {
                String[] args = s.split("=");
                if (args.length == 2) {
                    String regName = args[0];
                    if (regName.contains(":")) {
                        ResourceLocation rl = new ResourceLocation(regName);
                        if (ModList.get().isLoaded(rl.func_110624_b().toLowerCase())) {
                            try {
                                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
                                if (fluid != null) {
                                    try {
                                        int coldness = Integer.parseInt(args[1]);
                                        if (coldness < 2 && coldness > -101) {
                                            COOLANT_FLUIDS.put(fluid, coldness);
                                            Powah.LOGGER.info(Config.MARKER, "Added coolant fluid: {}, with coldness of: {} per mb", (Object)regName, (Object)args[1]);
                                            break block11;
                                        }
                                        Powah.LOGGER.warn(Config.MARKER, "Ignored coolant fluid: {}, with coldness > 1 or < -100: {}", (Object)regName, (Object)args[1]);
                                    }
                                    catch (Exception e) {
                                        Powah.LOGGER.fatal(Config.MARKER, "Ignored coolant fluid: {}, for incorrect args: {}", (Object)regName, (Object)args[1]);
                                        e.printStackTrace();
                                    }
                                    break block11;
                                }
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong coolant fluid registry name {}.", (Object)regName);
                            }
                            catch (Exception e) {
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong coolant fluid registry name {}.", (Object)regName);
                                e.printStackTrace();
                            }
                        } else {
                            Powah.LOGGER.warn(Config.MARKER, "Ignored coolant fluid for missing mod: {}.", (Object)rl.func_110624_b());
                        }
                    } else {
                        Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong coolant fluid registry name {}.", (Object)regName);
                    }
                }
            }
        });
        PowahAPI.COOLANTS.clear();
        PowahAPI.COOLANTS.putAll(COOLANT_FLUIDS);
    }

    static void collectHeatSources() {
        if (((Boolean)Configs.GENERAL.heatBlocksAPI.get()).booleanValue()) {
            HEAT_SOURCES.putAll(PowahAPI.HEAT_SOURCES);
        }
        ((List)Configs.GENERAL.heatBlocks.get()).forEach(s -> {
            block11: {
                String[] args = s.split("=");
                if (args.length == 2) {
                    String regName = args[0];
                    if (regName.contains(":")) {
                        ResourceLocation rl = new ResourceLocation(regName);
                        if (ModList.get().isLoaded(rl.func_110624_b().toLowerCase())) {
                            try {
                                Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
                                if (block != null) {
                                    try {
                                        int heat = Integer.parseInt(args[1]);
                                        if (heat > 0 && heat < 900000000) {
                                            HEAT_SOURCES.put(block, heat);
                                            Powah.LOGGER.info(Config.MARKER, "Added block: {}, with heat of: {}", (Object)regName, (Object)args[1]);
                                            break block11;
                                        }
                                        Powah.LOGGER.warn(Config.MARKER, "Ignored block: {}, with heat < 1 or > 900000000: {}", (Object)regName, (Object)args[1]);
                                    }
                                    catch (Exception e) {
                                        Powah.LOGGER.fatal(Config.MARKER, "Ignored block: {}, for incorrect args: {}", (Object)regName, (Object)args[1]);
                                        e.printStackTrace();
                                    }
                                    break block11;
                                }
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong block registry name {}.", (Object)regName);
                            }
                            catch (Exception e) {
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong block registry name {}.", (Object)regName);
                                e.printStackTrace();
                            }
                        } else {
                            Powah.LOGGER.warn(Config.MARKER, "Ignored block for missing mod: {}.", (Object)rl.func_110624_b());
                        }
                    } else {
                        Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong block registry name {}.", (Object)regName);
                    }
                }
            }
        });
        PowahAPI.HEAT_SOURCES.clear();
        PowahAPI.HEAT_SOURCES.putAll(HEAT_SOURCES);
    }

    static void collectMagmaticFluids() {
        if (((Boolean)Configs.MAGMATOR.magmaticFluidsAPI.get()).booleanValue()) {
            MAGMATIC_FLUIDS.putAll(PowahAPI.MAGMATIC_FLUIDS);
        }
        ((List)Configs.MAGMATOR.magmaticFluids.get()).forEach(s -> {
            block11: {
                String[] args = s.split("=");
                if (args.length == 2) {
                    String regName = args[0];
                    if (regName.contains(":")) {
                        ResourceLocation rl = new ResourceLocation(regName);
                        if (ModList.get().isLoaded(rl.func_110624_b().toLowerCase())) {
                            try {
                                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
                                if (fluid != null) {
                                    try {
                                        int heat = Integer.parseInt(args[1]);
                                        if (heat > 0 && heat <= 900000000) {
                                            MAGMATIC_FLUIDS.put(fluid, heat);
                                            Powah.LOGGER.info(Config.MARKER, "Added fluid: {}, with heat of: {} per 100 mb", (Object)regName, (Object)args[1]);
                                            break block11;
                                        }
                                        Powah.LOGGER.warn(Config.MARKER, "Ignored fluid: {}, with heat < 1 or > 900000000: {}", (Object)regName, (Object)args[1]);
                                    }
                                    catch (Exception e) {
                                        Powah.LOGGER.fatal(Config.MARKER, "Ignored fluid: {}, for incorrect args: {}", (Object)regName, (Object)args[1]);
                                        e.printStackTrace();
                                    }
                                    break block11;
                                }
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                            }
                            catch (Exception e) {
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                                e.printStackTrace();
                            }
                        } else {
                            Powah.LOGGER.warn(Config.MARKER, "Ignored fluid for missing mod: {}.", (Object)rl.func_110624_b());
                        }
                    } else {
                        Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                    }
                }
            }
        });
        PowahAPI.MAGMATIC_FLUIDS.clear();
        PowahAPI.MAGMATIC_FLUIDS.putAll(MAGMATIC_FLUIDS);
    }
}

