/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config.generator;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import owmii.lib.config.IEnergyProviderConfig;
import owmii.lib.energy.Energy;
import owmii.powah.block.Tier;

public class GeneratorConfig
implements IEnergyProviderConfig<Tier> {
    public final Map<Tier, Long> capacities = new HashMap<Tier, Long>();
    public final Map<Tier, Long> transfer = new HashMap<Tier, Long>();
    public final Map<Tier, Long> generation = new HashMap<Tier, Long>();
    public final ForgeConfigSpec.LongValue starterCap;
    public final ForgeConfigSpec.LongValue basicCap;
    public final ForgeConfigSpec.LongValue hardenedCap;
    public final ForgeConfigSpec.LongValue blazingCap;
    public final ForgeConfigSpec.LongValue nioticCap;
    public final ForgeConfigSpec.LongValue spiritedCap;
    public final ForgeConfigSpec.LongValue nitroCap;
    public final ForgeConfigSpec.LongValue starterTransfer;
    public final ForgeConfigSpec.LongValue basicTransfer;
    public final ForgeConfigSpec.LongValue hardenedTransfer;
    public final ForgeConfigSpec.LongValue blazingTransfer;
    public final ForgeConfigSpec.LongValue nioticTransfer;
    public final ForgeConfigSpec.LongValue spiritedTransfer;
    public final ForgeConfigSpec.LongValue nitroTransfer;
    public final ForgeConfigSpec.LongValue starterGeneration;
    public final ForgeConfigSpec.LongValue basicGeneration;
    public final ForgeConfigSpec.LongValue hardenedGeneration;
    public final ForgeConfigSpec.LongValue blazingGeneration;
    public final ForgeConfigSpec.LongValue nioticGeneration;
    public final ForgeConfigSpec.LongValue spiritedGeneration;
    public final ForgeConfigSpec.LongValue nitroGeneration;

    public GeneratorConfig(ForgeConfigSpec.Builder builder, long[] caps, long[] trs, long[] gens) {
        builder.push("Energy_Capacity");
        this.starterCap = builder.defineInRange("starterCap", caps[0], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.basicCap = builder.defineInRange("basicCap", caps[1], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.hardenedCap = builder.defineInRange("hardenedCap", caps[2], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.blazingCap = builder.defineInRange("blazingCap", caps[3], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nioticCap = builder.defineInRange("nioticCap", caps[4], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.spiritedCap = builder.defineInRange("spiritedCap", caps[5], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nitroCap = builder.defineInRange("nitroCap", caps[6], Energy.MIN.longValue(), Energy.MAX.longValue());
        builder.pop();
        builder.push("Energy_Transfer");
        this.starterTransfer = builder.defineInRange("starterTransfer", trs[0], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.basicTransfer = builder.defineInRange("basicTransfer", trs[1], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.hardenedTransfer = builder.defineInRange("hardenedTransfer", trs[2], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.blazingTransfer = builder.defineInRange("blazingTransfer", trs[3], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nioticTransfer = builder.defineInRange("nioticTransfer", trs[4], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.spiritedTransfer = builder.defineInRange("spiritedTransfer", trs[5], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nitroTransfer = builder.defineInRange("nitroTransfer", trs[6], Energy.MIN.longValue(), Energy.MAX.longValue());
        builder.pop();
        builder.push("Energy_Generation");
        this.starterGeneration = builder.defineInRange("starterGeneration", gens[0], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.basicGeneration = builder.defineInRange("basicGeneration", gens[1], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.hardenedGeneration = builder.defineInRange("hardenedGeneration", gens[2], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.blazingGeneration = builder.defineInRange("blazingGeneration", gens[3], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nioticGeneration = builder.defineInRange("nioticGeneration", gens[4], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.spiritedGeneration = builder.defineInRange("spiritedGeneration", gens[5], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nitroGeneration = builder.defineInRange("nitroGeneration", gens[6], Energy.MIN.longValue(), Energy.MAX.longValue());
        builder.pop();
    }

    public void reload() {
        this.capacities.put(Tier.STARTER, (Long)this.starterCap.get());
        this.capacities.put(Tier.BASIC, (Long)this.basicCap.get());
        this.capacities.put(Tier.HARDENED, (Long)this.hardenedCap.get());
        this.capacities.put(Tier.BLAZING, (Long)this.blazingCap.get());
        this.capacities.put(Tier.NIOTIC, (Long)this.nioticCap.get());
        this.capacities.put(Tier.SPIRITED, (Long)this.spiritedCap.get());
        this.capacities.put(Tier.NITRO, (Long)this.nitroCap.get());
        this.capacities.put(Tier.CREATIVE, Energy.MAX);
        this.transfer.put(Tier.STARTER, (Long)this.starterTransfer.get());
        this.transfer.put(Tier.BASIC, (Long)this.basicTransfer.get());
        this.transfer.put(Tier.HARDENED, (Long)this.hardenedTransfer.get());
        this.transfer.put(Tier.BLAZING, (Long)this.blazingTransfer.get());
        this.transfer.put(Tier.NIOTIC, (Long)this.nioticTransfer.get());
        this.transfer.put(Tier.SPIRITED, (Long)this.spiritedTransfer.get());
        this.transfer.put(Tier.NITRO, (Long)this.nitroTransfer.get());
        this.transfer.put(Tier.CREATIVE, Energy.MAX);
        this.generation.put(Tier.STARTER, (Long)this.starterGeneration.get());
        this.generation.put(Tier.BASIC, (Long)this.basicGeneration.get());
        this.generation.put(Tier.HARDENED, (Long)this.hardenedGeneration.get());
        this.generation.put(Tier.BLAZING, (Long)this.blazingGeneration.get());
        this.generation.put(Tier.NIOTIC, (Long)this.nioticGeneration.get());
        this.generation.put(Tier.SPIRITED, (Long)this.spiritedGeneration.get());
        this.generation.put(Tier.NITRO, (Long)this.nitroGeneration.get());
        this.generation.put(Tier.CREATIVE, Energy.MAX);
    }

    public long getCapacity(Tier variant) {
        if (this.capacities.containsKey((Object)variant)) {
            return this.capacities.get((Object)variant);
        }
        return 0L;
    }

    public long getTransfer(Tier variant) {
        if (this.transfer.containsKey((Object)variant)) {
            return this.transfer.get((Object)variant);
        }
        return 0L;
    }

    public long getGeneration(Tier variant) {
        if (this.generation.containsKey((Object)variant)) {
            return this.generation.get((Object)variant);
        }
        return 0L;
    }
}

