/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;
import owmii.powah.inventory.EnderCellContainer;
import owmii.powah.inventory.EnergyCableContainer;
import owmii.powah.inventory.EnergyCellContainer;
import owmii.powah.inventory.EnergyDischargerContainer;
import owmii.powah.inventory.EnergyHopperContainer;
import owmii.powah.inventory.FurnatorContainer;
import owmii.powah.inventory.MagmatorContainer;
import owmii.powah.inventory.PlayerTransmitterContainer;
import owmii.powah.inventory.ReactorContainer;
import owmii.powah.inventory.SolarPanelContainer;
import owmii.powah.inventory.ThermoGenContainer;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class IContainers {
    public static final List<ContainerType<?>> CONTAINER_TYPES = new ArrayList();
    public static final ContainerType<EnergyCellContainer> ENERGY_CELL = IContainers.register("energy_cell", EnergyCellContainer::create);
    public static final ContainerType<EnderCellContainer> ENDER_CELL = IContainers.register("ender_cell", EnderCellContainer::create);
    public static final ContainerType<EnergyCableContainer> ENERGY_CABLE = IContainers.register("energy_cable", EnergyCableContainer::create);
    public static final ContainerType<FurnatorContainer> FURNATOR = IContainers.register("furnator", FurnatorContainer::create);
    public static final ContainerType<MagmatorContainer> MAGMATOR = IContainers.register("magmator", MagmatorContainer::create);
    public static final ContainerType<ThermoGenContainer> THERMO_GEN = IContainers.register("thermo_gen", ThermoGenContainer::create);
    public static final ContainerType<SolarPanelContainer> SOLAR_PANEL = IContainers.register("solar_panel", SolarPanelContainer::create);
    public static final ContainerType<PlayerTransmitterContainer> PLAYER_TRANSMITTER = IContainers.register("player_transmitter", PlayerTransmitterContainer::create);
    public static final ContainerType<EnergyHopperContainer> ENERGY_HOPPER = IContainers.register("energy_hopper", EnergyHopperContainer::create);
    public static final ContainerType<EnergyDischargerContainer> ENERGY_DISCHARGER = IContainers.register("energy_discharger", EnergyDischargerContainer::create);
    public static final ContainerType<ReactorContainer> REACTOR = IContainers.register("reactor", ReactorContainer::create);

    private static <T extends Container> ContainerType<T> register(String name, IContainerFactory<T> factory) {
        ContainerType containerType = IForgeContainerType.create(factory);
        containerType.setRegistryName(name);
        CONTAINER_TYPES.add(containerType);
        return containerType;
    }

    @SubscribeEvent
    public static void onRegistry(RegistryEvent.Register<ContainerType<?>> event) {
        CONTAINER_TYPES.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
    }
}

