/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.lib.item.EnergyItem;
import owmii.lib.util.IVariant;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.Tier;
import owmii.powah.config.Configs;

public class BatteryItem
extends EnergyItem<Tier>
implements IEnderExtender {
    public BatteryItem(Item.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
    }

    public IEnergyConfig<Tier> getEnergyConfig() {
        return Configs.BATTERY;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof PlayerEntity && this.isCharging(stack)) {
            Energy.ifPresent((ItemStack)stack, storage -> {
                if (storage instanceof Energy) {
                    ((Energy)storage).chargeInventory((PlayerEntity)entity, stack1 -> !(stack1.func_77973_b() instanceof BatteryItem));
                }
            });
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            this.switchCharging(stack);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)Energy.get((ItemStack)stack).orElse((Object)Energy.Item.create((long)0L));
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)Energy.get((ItemStack)stack).orElse((Object)Energy.Item.create((long)0L));
        return 1.0 - (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isCharging(stack);
    }

    private void switchCharging(ItemStack stack) {
        this.setCharging(stack, !this.isCharging(stack));
    }

    private boolean isCharging(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("Charging");
    }

    private void setCharging(ItemStack stack, boolean charging) {
        stack.func_196082_o().func_74757_a("Charging", charging);
    }

    @Override
    public long getExtendedCapacity(ItemStack stack) {
        return this.getEnergyConfig().getCapacity(this.getVariant());
    }

    @Override
    public long getExtendedEnergy(ItemStack stack) {
        return Energy.getStored((ItemStack)stack);
    }
}

