/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.bambooblock;

import com.endlesnights.torchslabsmod.blocks.vanilla.BlockWallTorchSlab;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.pugz.bambooblocks.core.BambooBlocksRegistry;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBambooTorchWall
extends WallTorchBlock {
    private static final Map<Direction, VoxelShape> SHAPES_BOTTOM = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    private static final Map<Direction, VoxelShape> SHAPES_TOP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)5.5, (double)11.0, (double)11.0, (double)10.5, (double)21.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)5.5, (double)11.0, (double)0.0, (double)10.5, (double)21.0, (double)5.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)11.0, (double)11.0, (double)5.5, (double)16.0, (double)21.0, (double)10.5), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)5.5, (double)5.0, (double)21.0, (double)10.5)));
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;

    public BlockBambooTorchWall() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_200951_a(14).func_200947_a(SoundType.field_222468_o));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_196532_a, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)Half.BOTTOM));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196532_a, HALF});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(HALF) == Half.TOP) {
            return SHAPES_TOP.get(state.func_177229_b((IProperty)field_196532_a));
        }
        return SHAPES_BOTTOM.get(state.func_177229_b((IProperty)field_196532_a));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = ((Direction)state.func_177229_b((IProperty)field_196532_a)).func_176734_d();
        if (state.func_177229_b(HALF) == Half.BOTTOM && (worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof SlabBlock && worldIn.func_180495_p(pos.func_177972_a(direction)).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM || worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof StairsBlock && worldIn.func_180495_p(pos.func_177972_a(direction)).func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.BOTTOM || super.func_196260_a(state, worldIn, pos))) {
            return true;
        }
        if (state.func_177229_b(HALF) == Half.TOP && (worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof SlabBlock && worldIn.func_180495_p(pos.func_177972_a(direction)).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP || worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof StairsBlock && worldIn.func_180495_p(pos.func_177972_a(direction)).func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.TOP || super.func_196260_a(state, worldIn, pos))) {
            return BlockWallTorchSlab.validTop(worldIn.func_180495_p(pos.func_177984_a()), state);
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Direction direction = (Direction)stateIn.func_177229_b((IProperty)field_196532_a);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.8;
        double d2 = (double)pos.func_177952_p() + 0.5;
        if (stateIn.func_177229_b(HALF) == Half.TOP) {
            d1 += 0.5;
        }
        Direction direction1 = direction.func_176734_d();
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.18 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.18 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + 0.18 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.18 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)((Block)BambooBlocksRegistry.BAMBOO_TORCH.get()).func_199767_j());
    }
}

