/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.buzzierbees;

import com.bagel.buzzierbees.common.blocks.CandleBlock;
import com.endlesnights.torchslabsmod.blocks.buzzierbees.util.GetCandle;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPadCandle
extends Block {
    public static final IntegerProperty CANDLES = CandleBlock.CANDLES;
    public static final DirectionProperty FACING = CandleBlock.FACING;
    public static final VoxelShape PAD_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);
    protected static final VoxelShape ONE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.25, (double)10.0), (VoxelShape)PAD_SHAPE);
    protected static final VoxelShape TWO_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.25, (double)13.0), (VoxelShape)PAD_SHAPE);
    protected static final VoxelShape THREE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.25, (double)13.0), (VoxelShape)PAD_SHAPE);
    protected static final VoxelShape FOUR_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.25, (double)13.0), (VoxelShape)PAD_SHAPE);

    public BlockPadCandle(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)CANDLES, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CANDLES, FACING});
    }

    public int func_149750_m(BlockState state) {
        return super.func_149750_m(state) + (11 + 1 * (Integer)state.func_177229_b((IProperty)CANDLES));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((IProperty)CANDLES)) {
            default: {
                return ONE_SHAPE;
            }
            case 2: {
                return TWO_SHAPE;
            }
            case 3: {
                return THREE_SHAPE;
            }
            case 4: 
        }
        return FOUR_SHAPE;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (worldIn instanceof ServerWorld && entityIn instanceof BoatEntity) {
            worldIn.func_225521_a_(new BlockPos((Vec3i)pos), true, entityIn);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos blockpos) {
        return this.isValidGround(worldIn.func_180495_p(blockpos.func_177977_b()), (IBlockReader)worldIn, blockpos.func_177977_b());
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        IFluidState ifluidstate = worldIn.func_204610_c(pos);
        return ifluidstate.func_206886_c() == Fluids.field_204546_a || state.func_185904_a() == Material.field_151588_w;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)GetCandle.getPadParent(state).func_199767_j());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        double x = pos.func_177958_n();
        double y = (double)pos.func_177956_o() - 0.1;
        double z = pos.func_177952_p();
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 1) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.75, z + 0.5, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.75, z + 0.5, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5625, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5625, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.5625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.5625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.4375, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.4375, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.4375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.4375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.6875, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.6875, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.6875, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.6875, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
        }
        if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
        }
    }

    public static class ColorHandler
    implements IBlockColor {
        public int getColor(BlockState state, @Nullable ILightReader reader, @Nullable BlockPos blockPos, int tintIndex) {
            if (reader != null && blockPos != null) {
                return BiomeColors.func_228361_b_((ILightReader)reader, (BlockPos)blockPos);
            }
            return GrassColors.func_77480_a((double)0.5, (double)1.0);
        }
    }
}

