/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.druidcraft;

import com.endlesnights.naturalslabsmod.blocks.FenceSlabBlock;
import com.endlesnights.torchslabsmod.blocks.quark.BlockChainSlab;
import com.vulp.druidcraft.registry.ParticleRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockMothJarSlab
extends Block
implements IWaterLoggable {
    public static final BooleanProperty HANGING = BlockStateProperties.field_222514_j;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static IntegerProperty COLOR = IntegerProperty.func_177719_a((String)"color", (int)1, (int)6);
    int mothColor;

    BlockMothJarSlab(Block.Properties properties, int mothColor) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)COLOR, (Comparable)Integer.valueOf(mothColor)));
        this.mothColor = mothColor;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HANGING, WATERLOGGED, COLOR});
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (state == this.func_176223_P()) {
            return facing == Direction.DOWN && !this.func_196260_a(state, (IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
        return facing == Direction.UP && !this.func_196260_a(state, (IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            return world.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_206869_a().contains(SlabBlock.field_196505_a) && world.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM || ModList.get().isLoaded("naturalslabsmod") && world.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c() instanceof FenceSlabBlock;
        }
        return world.func_180495_p(pos.func_177972_a(Direction.UP)).func_206869_a().contains(SlabBlock.field_196505_a) && world.func_180495_p(pos.func_177972_a(Direction.UP)).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP || ModList.get().isLoaded("naturalslabsmod") && world.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c() instanceof FenceSlabBlock || world.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c() instanceof BlockChainSlab;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape lantern_grounded = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)-8.0, (double)4.0, (double)12.0, (double)0.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0));
        VoxelShape lantern_hanging = Block.func_208617_a((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0);
        if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            return VoxelShapes.func_197872_a((VoxelShape)lantern_hanging, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)22.0, (double)5.0, (double)14.0, (double)22.0, (double)11.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)22.0, (double)6.0, (double)10.0, (double)24.0, (double)10.0)));
        }
        return lantern_grounded;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public int[] colorLib(BlockState stateIn, Random rand) {
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 1) {
            if (rand.nextBoolean()) {
                return new int[]{80, 255, 155};
            }
            return new int[]{145, 255, 185};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 2) {
            if (rand.nextBoolean()) {
                return new int[]{245, 240, 220};
            }
            return new int[]{255, 255, 255};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 3) {
            if (rand.nextBoolean()) {
                return new int[]{175, 255, 105};
            }
            return new int[]{215, 255, 150};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 4) {
            if (rand.nextBoolean()) {
                return new int[]{255, 255, 150};
            }
            return new int[]{255, 255, 200};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 5) {
            if (rand.nextBoolean()) {
                return new int[]{255, 190, 75};
            }
            return new int[]{255, 220, 130};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 6) {
            if (rand.nextBoolean()) {
                return new int[]{255, 180, 230};
            }
            return new int[]{255, 225, 255};
        }
        return new int[]{0, 0, 0};
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.2;
        double d2 = (double)pos.func_177952_p() + 0.5;
        if (((Boolean)stateIn.func_177229_b((IProperty)HANGING)).booleanValue()) {
            d1 = (double)pos.func_177956_o() + 0.3;
        }
        int[] color = this.colorLib(stateIn, rand);
        float limit = 0.15f;
        d1 = ((Boolean)stateIn.func_177229_b((IProperty)HANGING)).booleanValue() ? (d1 += 0.5) : (d1 -= 0.5);
        float offset0 = Math.min(limit, Math.max(-limit, rand.nextFloat() - 0.5f));
        float offset1 = Math.min(limit, Math.max(-limit, rand.nextFloat() - 0.5f));
        float offset2 = Math.min(limit, Math.max(-limit, rand.nextFloat() - 0.5f));
        worldIn.func_195590_a((IParticleData)ParticleRegistry.magic_glitter, false, d0 + (double)offset0, d1 + (double)offset1, d2 + (double)offset2, (double)((float)color[0] / 255.0f), (double)((float)color[1] / 255.0f), (double)((float)color[2] / 255.0f));
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidState) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ResourceLocation func_220068_i() {
        switch (this.mothColor) {
            default: {
                return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:turquoise_lunar_moth_lantern"))).func_220068_i();
            }
            case 2: {
                return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:white_lunar_moth_lantern"))).func_220068_i();
            }
            case 3: {
                return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:lime_lunar_moth_lantern"))).func_220068_i();
            }
            case 4: {
                return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:yellow_lunar_moth_lantern"))).func_220068_i();
            }
            case 5: {
                return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:orange_lunar_moth_lantern"))).func_220068_i();
            }
            case 6: 
        }
        return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:pink_lunar_moth_lantern"))).func_220068_i();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        switch ((Integer)state.func_177229_b((IProperty)COLOR)) {
            default: {
                return new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:turquoise_lunar_moth_lantern")));
            }
            case 2: {
                return new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:white_lunar_moth_lantern")));
            }
            case 3: {
                return new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:lime_lunar_moth_lantern")));
            }
            case 4: {
                return new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:yellow_lunar_moth_lantern")));
            }
            case 5: {
                return new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:orange_lunar_moth_lantern")));
            }
            case 6: 
        }
        return new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("druidcraft:pink_lunar_moth_lantern")));
    }
}

