/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.hrznstudio.titanium.annotation.config.ConfigFile;
import com.hrznstudio.titanium.annotation.plugin.FeaturePlugin;
import com.hrznstudio.titanium.config.AnnotationConfigManager;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.Module;
import com.hrznstudio.titanium.plugin.PluginManager;
import com.hrznstudio.titanium.plugin.PluginPhase;
import com.hrznstudio.titanium.util.AnnotationUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ModuleController {
    private final String modid;
    private final Map<String, Module> moduleMap = new HashMap<String, Module>();
    private final Map<String, Module> disabledModuleMap = new HashMap<String, Module>();
    private final AnnotationConfigManager configManager = new AnnotationConfigManager();
    private final PluginManager modPluginManager;

    public ModuleController() {
        this.modid = ModLoadingContext.get().getActiveContainer().getModId();
        this.modPluginManager = new PluginManager(this.modid, FeaturePlugin.FeaturePluginType.MOD, featurePlugin -> ModList.get().isLoaded(featurePlugin.value()), true);
        this.modPluginManager.execute(PluginPhase.CONSTRUCTION);
        this.onPreInit();
        this.onInit();
        this.onPostInit();
    }

    private void addConfig(AnnotationConfigManager.Type type) {
        for (Class configClass : type.getConfigClass()) {
            if (!this.configManager.isClassManaged(configClass)) continue;
            return;
        }
        this.configManager.add(type);
    }

    public void onPreInit() {
        this.modPluginManager.execute(PluginPhase.PRE_INIT);
    }

    public void onInit() {
        this.initModules();
        if (!this.moduleMap.isEmpty()) {
            File modulesConfig = new File("config/" + this.modid + "/modules.toml");
            if (!modulesConfig.exists()) {
                modulesConfig.getParentFile().mkdirs();
            }
            CommentedFileConfig config = CommentedFileConfig.of((File)modulesConfig);
            config.load();
            new HashMap<String, Module>(this.moduleMap).forEach((id, m) -> {
                CommentedFileConfig tempFile = config;
                if (m.useCustomeFile()) {
                    File temp = new File("config/" + this.modid + "/" + id + ".toml");
                    if (!temp.exists()) {
                        temp.getParentFile().mkdirs();
                    }
                    tempFile = CommentedFileConfig.of((File)temp);
                    tempFile.load();
                }
                if (!m.isForced()) {
                    boolean active;
                    String cm = "modules." + id;
                    String c = cm + ".enabled";
                    tempFile.setComment(cm, m.getDescription());
                    boolean bl = active = tempFile.add(c, (Object)m.isEnabledByDefault()) ? m.isEnabledByDefault() : ((Boolean)config.getOrElse(c, (Object)m.isEnabledByDefault())).booleanValue();
                    if (active) {
                        m.initConfig(tempFile);
                    } else {
                        this.disabledModuleMap.put((String)id, this.moduleMap.remove(id));
                    }
                } else {
                    m.initConfig(tempFile);
                }
                if (m.useCustomeFile()) {
                    tempFile.save();
                    tempFile.close();
                }
            });
            config.save();
            config.close();
        }
        EventManager.mod(RegistryEvent.Register.class).process(event -> this.moduleMap.values().forEach(m -> {
            List<IForgeRegistryEntry> l = m.getEntries((Class)event.getGenericType());
            if (!l.isEmpty()) {
                l.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
            }
        })).subscribe();
        this.modPluginManager.execute(PluginPhase.INIT);
    }

    public void onPostInit() {
        AnnotationUtil.getFilteredAnnotatedClasses(ConfigFile.class, this.modid).forEach(aClass -> {
            ConfigFile annotation = aClass.getAnnotation(ConfigFile.class);
            this.addConfig(AnnotationConfigManager.Type.of(annotation.type(), aClass).setName(annotation.value()));
        });
        EventManager.mod(ModConfig.Loading.class).process(ev -> {
            this.configManager.inject();
            this.modPluginManager.execute(PluginPhase.CONFIG_LOAD);
        }).subscribe();
        EventManager.mod(ModConfig.Reloading.class).process(ev -> {
            this.configManager.inject();
            this.modPluginManager.execute(PluginPhase.CONFIG_RELOAD);
        }).subscribe();
        EventManager.mod(GatherDataEvent.class).process(this::addDataProvider).subscribe();
        EventManager.mod(FMLClientSetupEvent.class).process(fmlClientSetupEvent -> this.modPluginManager.execute(PluginPhase.CLIENT_SETUP)).subscribe();
        EventManager.mod(FMLCommonSetupEvent.class).process(fmlClientSetupEvent -> this.modPluginManager.execute(PluginPhase.COMMON_SETUP)).subscribe();
        this.modPluginManager.execute(PluginPhase.POST_INIT);
    }

    protected abstract void initModules();

    public void addModule(Module module) {
        this.moduleMap.put(module.getId(), module);
    }

    public void addModule(Module.Builder builder) {
        this.addModule(builder.build());
    }

    public void addDataProvider(GatherDataEvent event) {
    }
}

