/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.hrznstudio.titanium.block.BasicBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RayTraceUtils {
    public static RayTraceResult rayTraceSimple(World world, LivingEntity living, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = living.func_174824_e(partialTicks);
        Vec3d vec3d1 = living.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return world.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)living));
    }

    @Nullable
    public static VoxelShape rayTraceVoxelShape(BlockRayTraceResult original, World world, LivingEntity living, double blockReachDistance, float partialTicks) {
        BlockState og = world.func_180495_p(original.func_216350_a());
        if (og.func_177230_c() instanceof BasicBlock && ((BasicBlock)og.func_177230_c()).hasIndividualRenderVoxelShape()) {
            Vec3d vec3d = living.func_174824_e(partialTicks);
            Vec3d vec3d1 = living.func_70676_i(partialTicks);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
            List<VoxelShape> voxelShapes = ((BasicBlock)og.func_177230_c()).getBoundingBoxes(og, (IBlockReader)world, original.func_216350_a());
            VoxelShape closest = voxelShapes.get(0);
            double distance = Double.MAX_VALUE;
            for (VoxelShape voxelShape : voxelShapes) {
                BlockRayTraceResult result = voxelShape.func_212433_a(vec3d, vec3d2, original.func_216350_a());
                if (result == null || !(vec3d.func_72438_d(result.func_216347_e()) < distance)) continue;
                closest = voxelShape;
                distance = vec3d.func_72438_d(result.func_216347_e());
            }
            return closest;
        }
        return null;
    }
}

