/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks;

import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.items.ItemBlockHut;
import com.minecolonies.api.research.effects.AbstractResearchEffect;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockHut<B extends AbstractBlockHut<B>>
extends AbstractBlockMinecolonies<B>
implements IBuilderUndestroyable,
IAnchorBlock {
    private static final int HARDNESS_PVP_FACTOR = 4;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final float HARDNESS = 10.0f;
    public static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    protected boolean needsResearch = false;

    public AbstractBlockHut() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(10.0f, Float.POSITIVE_INFINITY).func_226896_b_());
        this.setRegistryName(this.getName());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().pvp_mode.get() != false ? 40.0f : 10.0f;
    }

    public AbstractBlockHut(Block.Properties properties) {
        super(properties.func_226896_b_());
        this.setRegistryName(this.getName());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public abstract String getName();

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        TileEntityColonyBuilding building = (TileEntityColonyBuilding)MinecoloniesTileEntities.BUILDING.func_200968_a();
        building.registryName = this.getBuildingEntry().getRegistryName();
        return building;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public abstract BuildingEntry getBuildingEntry();

    @NotNull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (worldIn.field_72995_K) {
            IBuildingView building = IColonyManager.getInstance().getBuildingView(worldIn.func_201675_m().func_186058_p().func_186068_a(), pos);
            if (building == null) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.nobuilding", (Object[])new Object[0]);
                return ActionResultType.FAIL;
            }
            if (building.getColony() == null) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.nocolony", (Object[])new Object[0]);
                return ActionResultType.FAIL;
            }
            if (!building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.permission.no", (Object[])new Object[0]);
                return ActionResultType.FAIL;
            }
            building.openGui(player.func_225608_bj_());
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195999_j() == null ? Direction.NORTH : Direction.func_176733_a((double)context.func_195999_j().field_70177_z);
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColonyBuilding) {
            IColony colony;
            TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
            if (hut.getBuildingName() != this.getBuildingEntry().getRegistryName()) {
                hut.registryName = this.getBuildingEntry().getRegistryName();
            }
            if ((colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, hut.getPosition())) != null) {
                colony.getBuildingManager().addNewBuilding(hut, worldIn);
                colony.getProgressManager().progressBuildingPlacement(this);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public void onBlockPlacedByBuildTool(@NotNull World worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, boolean mirror, String style) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof AbstractTileEntityColonyBuilding) {
            ((AbstractTileEntityColonyBuilding)tileEntity).setMirror(mirror);
            ((AbstractTileEntityColonyBuilding)tileEntity).setStyle(style);
        }
        this.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkResearch(IColonyView colony) {
        this.needsResearch = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void checkResearch(IColonyView colony, String researchId) {
        if (colony == null) {
            this.needsResearch = false;
            return;
        }
        this.needsResearch = colony.getResearchManager().getResearchEffects().getEffect(researchId, AbstractResearchEffect.class) == null;
    }

    @Override
    public void registerBlockItem(IForgeRegistry<Item> registry, Item.Properties properties) {
        registry.register(new ItemBlockHut(this, properties).setRegistryName(this.getRegistryName()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean needsResearch() {
        return this.needsResearch;
    }
}

