/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class Food
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Food.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private final int count;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Food(int count) {
        this.count = count;
    }

    public Food(int count, @NotNull ItemStack result) {
        this.count = count;
        this.result = result;
    }

    public static CompoundNBT serialize(IFactoryController controller, Food food) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a(NBT_COUNT, food.count);
        if (!ItemStackUtils.isEmpty(food.result).booleanValue()) {
            compound.func_218657_a(NBT_RESULT, (INBT)food.result.serializeNBT());
        }
        return compound;
    }

    public static Food deserialize(IFactoryController controller, CompoundNBT compound) {
        int count = compound.func_74762_e(NBT_COUNT);
        ItemStack result = compound.func_150296_c().contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        return new Food(count, result);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, Food input) {
        buffer.writeInt(input.count);
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.result) == false);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            buffer.func_150788_a(input.result);
        }
    }

    public static Food deserialize(IFactoryController controller, PacketBuffer buffer) {
        int count = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? buffer.func_150791_c() : ItemStack.field_190927_a;
        return new Food(count, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return stack.func_77973_b().func_219971_r();
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(@NotNull int newCount) {
        return new Food(newCount);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Food)) {
            return false;
        }
        Food food = (Food)o;
        if (this.getCount() != food.getCount()) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), food.getResult());
    }

    public int hashCode() {
        int result1 = this.getCount();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

