/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.NotNull;

public class Tool
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Tool.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_TYPE = "Type";
    private static final String NBT_MIN_LEVEL = "MinLevel";
    private static final String NBT_MAX_LEVEL = "MaxLevel";
    private static final String NBT_RESULT = "Result";
    @NotNull
    private final IToolType toolClass;
    @NotNull
    private final Integer minLevel;
    @NotNull
    private final Integer maxLevel;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Tool(@NotNull IToolType toolClass, @NotNull Integer minLevel, @NotNull Integer maxLevel) {
        this(toolClass, minLevel, maxLevel, ItemStackUtils.EMPTY);
    }

    public Tool(@NotNull IToolType toolClass, @NotNull Integer minLevel, @NotNull Integer maxLevel, @NotNull ItemStack result) {
        this.toolClass = toolClass;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.result = result;
    }

    @NotNull
    public static CompoundNBT serialize(IFactoryController controller, Tool tool) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a(NBT_TYPE, tool.getToolClass().getName());
        compound.func_74768_a(NBT_MIN_LEVEL, tool.getMinLevel().intValue());
        compound.func_74768_a(NBT_MAX_LEVEL, tool.getMaxLevel().intValue());
        compound.func_218657_a(NBT_RESULT, (INBT)tool.getResult().serializeNBT());
        return compound;
    }

    @NotNull
    public static Tool deserialize(IFactoryController controller, CompoundNBT nbt) {
        IToolType type = com.minecolonies.api.util.constant.ToolType.getToolType(nbt.func_74779_i(NBT_TYPE));
        Integer minLevel = nbt.func_74762_e(NBT_MIN_LEVEL);
        Integer maxLevel = nbt.func_74762_e(NBT_MAX_LEVEL);
        ItemStack result = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(NBT_RESULT));
        return new Tool(type, minLevel, maxLevel, result);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, Tool input) {
        buffer.func_180714_a(input.getToolClass().getName());
        buffer.writeInt(input.getMinLevel().intValue());
        buffer.writeInt(input.getMaxLevel().intValue());
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.result) == false);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            buffer.func_150788_a(input.result);
        }
    }

    public static Tool deserialize(IFactoryController controller, PacketBuffer buffer) {
        IToolType type = com.minecolonies.api.util.constant.ToolType.getToolType(buffer.func_218666_n());
        int minLevel = buffer.readInt();
        int maxLevel = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? buffer.func_150791_c() : ItemStack.field_190927_a;
        return new Tool(type, minLevel, maxLevel, result);
    }

    @NotNull
    public IToolType getToolClass() {
        return this.toolClass;
    }

    @NotNull
    public Integer getMinLevel() {
        return this.minLevel;
    }

    @NotNull
    public Integer getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        boolean toolTypeResult;
        boolean bl = toolTypeResult = ItemStackUtils.isEmpty(stack) == false && stack.func_190916_E() >= 1 && this.getToolClasses(stack).stream().filter(s -> this.getToolClass().getName().equalsIgnoreCase((String)s)).map(com.minecolonies.api.util.constant.ToolType::getToolType).anyMatch(t -> t != com.minecolonies.api.util.constant.ToolType.NONE && (stack.func_77952_i() > 0 || !stack.func_77951_h()) && ItemStackUtils.hasToolLevel(stack, t, this.getMinLevel(), this.getMaxLevel()));
        if (!toolTypeResult) {
            return stack.func_77973_b() instanceof HoeItem && this.toolClass.equals(com.minecolonies.api.util.constant.ToolType.HOE) || stack.func_77973_b() instanceof ShieldItem && this.toolClass.equals(com.minecolonies.api.util.constant.ToolType.SHIELD);
        }
        return toolTypeResult;
    }

    private Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return set;
        }
        set.addAll(stack.func_77973_b().getToolTypes(stack).stream().map(ToolType::getName).collect(Collectors.toList()));
        if (stack.func_77973_b() instanceof BowItem) {
            set.add("bow");
        } else if (stack.func_77973_b() instanceof SwordItem || Compatibility.isTinkersWeapon(stack)) {
            set.add("weapon");
        } else if (stack.func_77973_b() instanceof HoeItem) {
            set.add("hoe");
        } else if (stack.func_77973_b() instanceof FishingRodItem) {
            set.add("rod");
        } else if (stack.func_77973_b() instanceof ShearsItem) {
            set.add("shears");
        } else if (stack.func_77973_b() instanceof ShieldItem) {
            set.add("shield");
        } else if (stack.func_77973_b() instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)stack.func_77973_b();
            if (armor.func_185083_B_() == EquipmentSlotType.CHEST) {
                set.add("chestplate");
            } else if (armor.func_185083_B_() == EquipmentSlotType.FEET) {
                set.add("boots");
            } else if (armor.func_185083_B_() == EquipmentSlotType.HEAD) {
                set.add("helmet");
            } else if (armor.func_185083_B_() == EquipmentSlotType.LEGS) {
                set.add("leggings");
            }
        }
        return set;
    }

    public boolean isArmor() {
        return this.toolClass == com.minecolonies.api.util.constant.ToolType.HELMET || this.toolClass == com.minecolonies.api.util.constant.ToolType.LEGGINGS || this.toolClass == com.minecolonies.api.util.constant.ToolType.CHESTPLATE || this.toolClass == com.minecolonies.api.util.constant.ToolType.BOOTS;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(@NotNull int newCount) {
        return new Tool(this.toolClass, this.minLevel, this.maxLevel, this.result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tool)) {
            return false;
        }
        Tool tool = (Tool)o;
        if (!this.getToolClass().equals(tool.getToolClass())) {
            return false;
        }
        if (!this.getMinLevel().equals(tool.getMinLevel())) {
            return false;
        }
        if (!this.getMaxLevel().equals(tool.getMaxLevel())) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), tool.getResult());
    }

    public int hashCode() {
        int result1 = this.getToolClass().hashCode();
        result1 = 31 * result1 + this.getMinLevel().hashCode();
        result1 = 31 * result1 + this.getMaxLevel().hashCode();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

