/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class PrivateCrafting
extends AbstractCrafting {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(PrivateCrafting.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());

    public PrivateCrafting(@NotNull ItemStack stack, int count, int minCount) {
        super(stack, count, minCount);
    }

    public static CompoundNBT serialize(IFactoryController controller, PrivateCrafting input) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Stack", (INBT)input.getStack().serializeNBT());
        compound.func_74768_a("Count", input.getCount());
        compound.func_74768_a("Count", input.getMinCount());
        return compound;
    }

    public static PrivateCrafting deserialize(IFactoryController controller, CompoundNBT compound) {
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.func_74775_l("Stack"));
        int count = compound.func_74762_e("Count");
        int minCount = compound.func_74762_e("Count");
        return new PrivateCrafting(stack, count, minCount == 0 ? count : minCount);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, PrivateCrafting input) {
        buffer.func_150788_a(input.getStack());
        buffer.writeInt(input.getCount());
        buffer.writeInt(input.getMinCount());
    }

    public static PrivateCrafting deserialize(IFactoryController controller, PacketBuffer buffer) {
        ItemStack stack = buffer.func_150791_c();
        int count = buffer.readInt();
        int minCount = buffer.readInt();
        return new PrivateCrafting(stack, count, minCount == 0 ? count : minCount);
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

