/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.deliveryman;

import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.IDeliverymanRequestable;

public abstract class AbstractDeliverymanRequestable
implements IDeliverymanRequestable {
    protected static final String NBT_PRIORITY = "Priority";
    private static final int MAX_BUILDING_PRIORITY = 10;
    private static final int DEFAULT_DELIVERY_PRIORITY = 13;
    private static final int MAX_AGING_PRIORITY = 14;
    private static final int PLAYER_ACTION_PRIORITY = 15;
    protected int priority = 0;

    protected AbstractDeliverymanRequestable(int priority) {
        this.priority = priority;
    }

    public static int scaledPriority(int priority) {
        return priority;
    }

    public static int getMaxBuildingPriority(boolean returnScaled) {
        return returnScaled ? AbstractDeliverymanRequestable.scaledPriority(10) : 10;
    }

    public static int getDefaultDeliveryPriority(boolean returnScaled) {
        return returnScaled ? AbstractDeliverymanRequestable.scaledPriority(13) : 13;
    }

    public static int getMaxAgingPriority(boolean returnScaled) {
        return returnScaled ? AbstractDeliverymanRequestable.scaledPriority(14) : 14;
    }

    public static int getPlayerActionPriority(boolean returnScaled) {
        return returnScaled ? AbstractDeliverymanRequestable.scaledPriority(15) : 15;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void incrementPriorityDueToAging() {
        this.priority = Math.min(AbstractDeliverymanRequestable.getMaxAgingPriority(true), this.priority + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDeliverymanRequestable)) {
            return false;
        }
        return this.getPriority() == ((AbstractDeliverymanRequestable)o).getPriority();
    }

    public int hashCode() {
        return this.getPriority();
    }
}

