/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockStateStorage;
import com.minecolonies.api.util.Disease;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.BlockItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CompatibilityManager
implements ICompatibilityManager {
    private final Map<BlockStateStorage, ItemStorage> leavesToSaplingMap = new HashMap<BlockStateStorage, ItemStorage>();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final List<IProperty<?>> leafCompareWithoutProperties = ImmutableList.of((Object)checkDecay, (Object)decayable, (Object)DYN_PROP_HYDRO, (Object)TREE_DISTANCE);
    private static final BooleanProperty checkDecay = BooleanProperty.func_177716_a((String)"check_decay");
    private static final BooleanProperty decayable = BooleanProperty.func_177716_a((String)"decayable");
    public static final IntegerProperty DYN_PROP_HYDRO = IntegerProperty.func_177719_a((String)"hydro", (int)1, (int)4);
    public static final IntegerProperty TREE_DISTANCE = IntegerProperty.func_177719_a((String)"distance", (int)1, (int)7);
    private final Set<Block> oreBlocks = new HashSet<Block>();
    private final Set<ItemStorage> smeltableOres = new HashSet<ItemStorage>();
    private final Set<ItemStorage> compostableItems = new HashSet<ItemStorage>();
    private final Set<ItemStorage> plantables = new HashSet<ItemStorage>();
    private final Set<ItemStorage> fuel = new HashSet<ItemStorage>();
    private final Set<ItemStorage> food = new HashSet<ItemStorage>();
    private final Map<String, Disease> diseases = new HashMap<String, Disease>();
    private final List<String> diseaseList = new ArrayList<String>();
    private final List<ItemStorage> luckyOres = new ArrayList<ItemStorage>();
    private final Map<ItemStorage, ItemStorage> crusherModes = new HashMap<ItemStorage, ItemStorage>();
    private final List<Tuple<Item, Integer>> recruitmentCostsWeights = new ArrayList<Tuple<Item, Integer>>();
    private final List<Tuple<ItemStorage, Double>> sifterMeshes = new ArrayList<Tuple<ItemStorage, Double>>();
    private final List<ItemStorage> sievableBlocks = new ArrayList<ItemStorage>();
    private final Map<ItemStorage, Map<ItemStorage, List<ItemStorage>>> sieveResult = new HashMap<ItemStorage, Map<ItemStorage, List<ItemStorage>>>();
    private final Map<Integer, List<Tuple<String, Integer>>> enchantments = new HashMap<Integer, List<Tuple<String, Integer>>>();
    private boolean discoveredAlready = false;
    private static final Random random = new Random();
    private static ImmutableList<ItemStack> allBlocks = ImmutableList.builder().build();

    @Override
    public List<Tuple<ItemStorage, Double>> getMeshes() {
        return new ArrayList<Tuple<ItemStorage, Double>>(this.sifterMeshes);
    }

    @Override
    public ArrayList<ItemStorage> getSievableBlock() {
        return new ArrayList<ItemStorage>(this.sievableBlocks);
    }

    @Override
    public ItemStack getRandomSieveResultForMeshAndBlock(ItemStorage mesh, ItemStorage block, int attempts) {
        if (this.sieveResult.containsKey(mesh) && this.sieveResult.get(mesh).containsKey(block)) {
            List<ItemStorage> drops = this.sieveResult.get(mesh).get(block);
            Collections.shuffle(drops);
            for (int i = 0; i < attempts && drops.size() > i; ++i) {
                ItemStack result = drops.get(i).getItemStack();
                if (result.func_190926_b()) continue;
                return result.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void discover(boolean serverSide) {
        this.discoverBlockList();
        this.discoverSaplings();
        this.discoverOres();
        Log.getLogger().info("Finished discovering oreBlocks");
        this.discoverCompostableItems();
        this.discoverPlantables();
        this.discoverLuckyOres();
        this.discoverRecruitCosts();
        this.discoverDiseases();
        this.discoverCrusherModes();
        this.discoverSifting();
        this.discoverFood();
        this.discoverFuel();
        this.discoverEnchantments();
        this.discoveredAlready = true;
    }

    private void discoverBlockList() {
        allBlocks = ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(ForgeRegistries.ITEMS.iterator(), 16), false).map(ItemStack::new).collect(Collectors.toList()));
    }

    @Override
    public List<ItemStack> getBlockList() {
        return allBlocks;
    }

    @Override
    public boolean isCompost(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b().func_219971_r() || itemStack.func_77973_b() instanceof BlockItem && (((BlockItem)itemStack.func_77973_b()).func_179223_d() instanceof CropsBlock || ((BlockItem)itemStack.func_77973_b()).func_179223_d() instanceof StemBlock)) {
            return true;
        }
        for (String string : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().listOfCompostableItems.get()) {
            if (itemStack.func_77973_b().getRegistryName().toString().equals(string)) {
                return true;
            }
            for (ResourceLocation tag : itemStack.func_77973_b().getTags()) {
                if (!tag.toString().contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPlantable(ItemStack itemStack) {
        if (itemStack.func_190926_b() || itemStack.func_77973_b() == Items.field_221690_bg || !(itemStack.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        for (String string : (List)IMinecoloniesAPI.getInstance().getConfig().getCommon().listOfPlantables.get()) {
            if (itemStack.func_77973_b().getRegistryName().toString().equals(string)) {
                return true;
            }
            String[] split = string.split(":");
            if (split.length == 1) {
                String[] newSplit = new String[2];
                newSplit[1] = split[0];
                newSplit[0] = "minecraft";
                split = newSplit;
            }
            if (split.length != 2) continue;
            for (ResourceLocation tag : itemStack.func_77973_b().getTags()) {
                if (!tag.toString().contains(":" + split[1]) || !itemStack.func_77973_b().getRegistryName().func_110624_b().equals(split[0])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLuckyBlock(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (String string : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().luckyBlocks.get()) {
            if (itemStack.func_77973_b().getRegistryName().toString().equals(string)) {
                return true;
            }
            for (ResourceLocation tag : itemStack.func_77973_b().getTags()) {
                if (!tag.func_110623_a().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getSaplingForLeaf(BlockState block) {
        BlockStateStorage tempLeaf = new BlockStateStorage(block, this.leafCompareWithoutProperties, true);
        if (this.leavesToSaplingMap.containsKey(tempLeaf)) {
            return this.leavesToSaplingMap.get(tempLeaf).getItemStack();
        }
        return null;
    }

    @Override
    public List<ItemStorage> getCopyOfSaplings() {
        return new ArrayList<ItemStorage>(this.saplings);
    }

    @Override
    public Set<ItemStorage> getFuel() {
        return this.fuel;
    }

    @Override
    public Set<ItemStorage> getFood() {
        return this.food;
    }

    @Override
    public Set<ItemStorage> getSmeltableOres() {
        return this.smeltableOres;
    }

    @Override
    public List<ItemStorage> getCopyOfCompostableItems() {
        return ImmutableList.copyOf(this.compostableItems);
    }

    @Override
    public List<ItemStorage> getCopyOfPlantables() {
        return ImmutableList.copyOf(this.plantables);
    }

    @Override
    public String getRandomDisease() {
        return this.diseaseList.get(random.nextInt(this.diseaseList.size()));
    }

    @Override
    public Disease getDisease(String disease) {
        return this.diseases.get(disease);
    }

    @Override
    public List<Disease> getDiseases() {
        return new ArrayList<Disease>(this.diseases.values());
    }

    @Override
    public List<Tuple<Item, Integer>> getRecruitmentCostsWeights() {
        return Collections.unmodifiableList(this.recruitmentCostsWeights);
    }

    @Override
    public boolean isOre(BlockState block) {
        if (block.func_177230_c() instanceof OreBlock || block.func_177230_c() instanceof RedstoneOreBlock) {
            return true;
        }
        return this.oreBlocks.contains(block.func_177230_c());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        if (stack.func_77973_b().func_206844_a(Tags.Items.ORES)) {
            return !MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack).func_190926_b();
        }
        for (ResourceLocation tag : stack.func_77973_b().getTags()) {
            if (!tag.func_110623_a().contains("ore")) continue;
            return !MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack).func_190926_b();
        }
        return false;
    }

    @Override
    public boolean isMineableOre(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        if (stack.func_77973_b().func_206844_a(Tags.Items.ORES)) {
            return true;
        }
        for (ResourceLocation tag : stack.func_77973_b().getTags()) {
            if (!tag.func_110623_a().contains("ore")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<ItemStorage, ItemStorage> getCrusherModes() {
        return ImmutableMap.builder().putAll(this.crusherModes).build();
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        ListNBT saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().filter(entry -> entry.getKey() != null).map(entry -> CompatibilityManager.writeLeafSaplingEntryToNBT(((BlockStateStorage)entry.getKey()).getState(), (ItemStorage)entry.getValue())).collect(NBTUtils.toListNBT());
        compound.func_218657_a("tagSapLeaves", (INBT)saplingsLeavesTagList);
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        NBTUtils.streamCompound(compound.func_150295_c("tagSapLeaves", 10)).map(CompatibilityManager::readLeafSaplingEntryFromNBT).filter(key -> !this.leavesToSaplingMap.containsKey(new BlockStateStorage((BlockState)key.getA(), this.leafCompareWithoutProperties, true)) && !this.leavesToSaplingMap.containsValue(key.getB())).forEach(key -> this.leavesToSaplingMap.put(new BlockStateStorage((BlockState)key.getA(), this.leafCompareWithoutProperties, true), (ItemStorage)key.getB()));
    }

    @Override
    public void connectLeafToSapling(BlockState leaf, ItemStack stack) {
        BlockStateStorage store = new BlockStateStorage(leaf, this.leafCompareWithoutProperties, true);
        if (!this.leavesToSaplingMap.containsKey(store)) {
            this.leavesToSaplingMap.put(store, new ItemStorage(stack, false, true));
        }
    }

    @Override
    public boolean isDiscoveredAlready() {
        return this.discoveredAlready;
    }

    @Override
    public ItemStack getRandomLuckyOre(double chanceBonus) {
        if (random.nextDouble() * 100.0 <= (double)((Integer)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().luckyBlockChance.get()).intValue() * chanceBonus) {
            return this.luckyOres.get(random.nextInt(this.luckyOres.size())).getItemStack().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Tuple<ItemStack, Integer> getRandomEnchantmentBook(int buildingLevel) {
        List list = this.enchantments.getOrDefault(buildingLevel, new ArrayList());
        Tuple ench = list.isEmpty() ? new Tuple("protection", 1) : (Tuple)list.get(random.nextInt(list.size()));
        return new Tuple<ItemStack, Integer>(EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation((String)ench.getA())), ((Integer)ench.getB()).intValue())), (Integer)ench.getB());
    }

    private void discoverOres() {
        if (this.smeltableOres.isEmpty()) {
            this.smeltableOres.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(this::isOre).map(ItemStorage::new).collect(Collectors.toList())));
        }
        if (this.oreBlocks.isEmpty()) {
            this.oreBlocks.addAll((Collection<Block>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(this::isMineableOre).filter(stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77973_b() instanceof BlockItem).map(stack -> ((BlockItem)stack.func_77973_b()).func_179223_d()).collect(Collectors.toList())));
            for (String oreString : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().extraOres.get()) {
                String[] split = oreString.split(":");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0], split[1]));
                if (block == null || this.oreBlocks.contains(block) || block instanceof AirBlock) continue;
                this.oreBlocks.add(block);
            }
        }
        Log.getLogger().info("Finished discovering Ores");
    }

    private void discoverSaplings() {
        for (Item item : ItemTags.field_200037_g.func_199885_a()) {
            ItemStack stack = new ItemStack((IItemProvider)item);
            this.saplings.add(new ItemStorage(stack, false, true));
        }
        Log.getLogger().info("Finished discovering saplings");
    }

    private void discoverCompostableItems() {
        if (this.compostableItems.isEmpty()) {
            this.compostableItems.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(this::isCompost).map(ItemStorage::new).collect(Collectors.toList())));
        }
        Log.getLogger().info("Finished discovering compostables");
    }

    private void discoverPlantables() {
        if (this.plantables.isEmpty()) {
            this.plantables.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(this::isPlantable).map(ItemStorage::new).collect(Collectors.toList())));
        }
        Log.getLogger().info("Finished discovering plantables");
    }

    private void discoverFuel() {
        if (this.fuel.isEmpty()) {
            this.fuel.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(AbstractFurnaceTileEntity::func_213991_b).map(ItemStorage::new).collect(Collectors.toList())));
        }
        Log.getLogger().info("Finished discovering fuel");
    }

    private void discoverFood() {
        if (this.food.isEmpty()) {
            this.food.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(ItemStackUtils.ISFOOD.or(ItemStackUtils.ISCOOKABLE)).map(ItemStorage::new).collect(Collectors.toList())));
        }
        Log.getLogger().info("Finished discovering food");
    }

    private void discoverLuckyOres() {
        if (this.luckyOres.isEmpty()) {
            for (String ore : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().luckyOres.get()) {
                String[] split = ore.split("!");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured ore: " + ore);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null || item == Items.field_190931_a) {
                    Log.getLogger().warn("Invalid lucky block: " + ore);
                    continue;
                }
                ItemStack stack = new ItemStack((IItemProvider)item, 1);
                try {
                    int rarity = Integer.parseInt(split[split.length - 1]);
                    for (int i = 0; i < rarity; ++i) {
                        this.luckyOres.add(new ItemStorage(stack));
                    }
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Ore has invalid rarity: " + ore);
                }
            }
        }
        Log.getLogger().info("Finished discovering lucky oreBlocks");
    }

    private void discoverRecruitCosts() {
        if (this.recruitmentCostsWeights.isEmpty()) {
            for (String itemString : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().configListRecruitmentItems.get()) {
                String[] split = itemString.split(";");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured recruitment cost: " + itemString);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null || item == Items.field_190931_a) {
                    Log.getLogger().warn("Invalid recruitment item: " + item);
                    continue;
                }
                try {
                    int rarity = Integer.parseInt(split[split.length - 1]);
                    this.recruitmentCostsWeights.add(new Tuple<Item, Integer>(item, rarity));
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Invalid recruitment weight for: " + item);
                }
            }
        }
        Log.getLogger().info("Finished discovering recruitment costs");
    }

    private void discoverDiseases() {
        if (this.diseases.isEmpty()) {
            for (String disease : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().diseases.get()) {
                String[] split = disease.split(",");
                if (split.length < 3) {
                    Log.getLogger().warn("Wrongly configured disease: " + disease);
                    continue;
                }
                try {
                    int i;
                    String name = split[0];
                    int rarity = Integer.parseInt(split[1]);
                    ArrayList<ItemStack> cure = new ArrayList<ItemStack>();
                    for (i = 2; i < split.length; ++i) {
                        String[] theItem = split[i].split(":");
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(theItem[0], theItem[1]));
                        if (item == null || item == Items.field_190931_a) {
                            Log.getLogger().warn("Invalid cure item: " + disease);
                            continue;
                        }
                        ItemStack stack = new ItemStack((IItemProvider)item, 1);
                        cure.add(stack);
                    }
                    this.diseases.put(name, new Disease(name, rarity, cure));
                    for (i = 0; i < rarity; ++i) {
                        this.diseaseList.add(name);
                    }
                }
                catch (NumberFormatException e) {
                    Log.getLogger().warn("Wrongly configured disease: " + disease);
                }
            }
        }
        Log.getLogger().info("Finished discovering diseases");
    }

    private void discoverSifting() {
        double probability;
        for (String string : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().sifterMeshes.get()) {
            String[] stringArray = string.split(",");
            if (stringArray.length != 2) {
                Log.getLogger().warn("Couldn't parse the mesh: " + string);
                continue;
            }
            try {
                double probability2 = Double.parseDouble(stringArray[1]);
                String[] item = stringArray[0].split(":");
                Item theItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item[0], item[1]));
                if (theItem == null) {
                    Log.getLogger().warn("Couldn't find item for mesh: " + string);
                    continue;
                }
                ItemStack stack = new ItemStack((IItemProvider)theItem, 1);
                this.sifterMeshes.add(new Tuple<ItemStorage, Double>(new ItemStorage(stack), probability2));
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Couldn't retrieve probability for mesh: " + string, (Throwable)ex);
            }
        }
        for (String string : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().siftableBlocks.get()) {
            try {
                String[] stringArray = string.split(":");
                Item theItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(stringArray[0], stringArray[1]));
                if (theItem == null) {
                    Log.getLogger().warn("Couldn't find item for siftable block: " + string);
                    continue;
                }
                ItemStack stack = new ItemStack((IItemProvider)theItem, 1);
                this.sievableBlocks.add(new ItemStorage(stack));
            }
            catch (NumberFormatException numberFormatException) {
                Log.getLogger().warn("Couldn't retrieve the metadata for siftable block: " + string, (Throwable)numberFormatException);
            }
        }
        HashMap tempDrops = new HashMap();
        for (String string : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().sifterDrops.get()) {
            String[] drop = string.split(",");
            if (drop.length != 4) {
                Log.getLogger().warn("Required Parameters: keyBlock, keyMesh, item, probability, not met in: " + string);
                continue;
            }
            try {
                int block = Integer.parseInt(drop[0]);
                if (this.sievableBlocks.size() < block) {
                    Log.getLogger().warn("Trying to add siftresult for not configured block.");
                    continue;
                }
                ItemStorage blockStorage = this.sievableBlocks.get(block);
                int mesh = Integer.parseInt(drop[1]);
                if (this.sifterMeshes.size() < mesh) {
                    Log.getLogger().warn("Trying to add siftresult for not configured mesh.");
                    continue;
                }
                ItemStorage meshStorage = this.sifterMeshes.get(mesh).getA();
                String[] item = drop[2].split(":");
                Item theItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item[0], item[1]));
                if (theItem == null || theItem == Items.field_190931_a) {
                    Log.getLogger().warn("Couldn't find item for siftable block: " + string);
                    continue;
                }
                ItemStack stack = new ItemStack((IItemProvider)theItem, 1);
                probability = Double.parseDouble(drop[3]);
                Map map = tempDrops.containsKey(meshStorage) ? (Map)tempDrops.get(meshStorage) : new HashMap();
                Map drops = map.containsKey(blockStorage) ? (Map)map.get(blockStorage) : new HashMap();
                drops.put(new ItemStorage(stack), probability);
                map.put(blockStorage, drops);
                tempDrops.put(meshStorage, map);
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Couldn't retrieve block or mesh for drop: " + string, (Throwable)ex);
            }
        }
        for (Map.Entry entry : tempDrops.entrySet()) {
            for (Map.Entry blockEntry : ((Map)entry.getValue()).entrySet()) {
                ArrayList<ItemStorage> theDrops = new ArrayList<ItemStorage>();
                double probabilitySum = 0.0;
                for (Map.Entry drops : ((Map)blockEntry.getValue()).entrySet()) {
                    ItemStorage storage = (ItemStorage)drops.getKey();
                    probability = (Double)drops.getValue();
                    probabilitySum += probability;
                    int i = 0;
                    while ((double)i < probability) {
                        theDrops.add(storage);
                        ++i;
                    }
                }
                ItemStorage airStorage = new ItemStorage(ItemStack.field_190927_a);
                int i = 0;
                while ((double)i < 100.0 - probabilitySum) {
                    theDrops.add(airStorage);
                    ++i;
                }
                Map<Object, List<ItemStorage>> map = this.sieveResult.containsKey(entry.getKey()) ? this.sieveResult.get(entry.getKey()) : new HashMap();
                map.put(blockEntry.getKey(), theDrops);
                this.sieveResult.put((ItemStorage)entry.getKey(), (Map<ItemStorage, List<ItemStorage>>)map);
            }
        }
        Log.getLogger().info("Finished initiating sifter config");
    }

    private void discoverEnchantments() {
        for (String string : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().enchantments.get()) {
            String[] split = string.split(",");
            if (split.length != 4) {
                Log.getLogger().warn("Invalid enchantment mode setting: " + string);
                continue;
            }
            try {
                String enchantment = split[1];
                if (ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantment)) == null) {
                    Log.getLogger().warn("Enchantment: " + enchantment + " doesn't exist!");
                    continue;
                }
                int buildingLevel = Integer.parseInt(split[0]);
                int enchantmentLevel = Integer.parseInt(split[2]);
                int numberOfTickets = Integer.parseInt(split[3]);
                for (int level = buildingLevel; level <= 5; ++level) {
                    List list = this.enchantments.getOrDefault(level, new ArrayList());
                    for (int i = 0; i < numberOfTickets; ++i) {
                        list.add(new Tuple<String, Integer>(enchantment, enchantmentLevel));
                    }
                    this.enchantments.put(level, list);
                }
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Invalid integer at pos 1, 3 or 4");
            }
        }
    }

    private void discoverCrusherModes() {
        for (String string : (List)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().crusherProduction.get()) {
            String[] split = string.split("!");
            if (split.length != 2) {
                Log.getLogger().warn("Invalid crusher mode setting: " + string);
                continue;
            }
            String[] firstItem = split[0].split(":");
            String[] secondItem = split[1].split(":");
            Item item1 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(firstItem[0], firstItem[1]));
            Item item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(secondItem[0], secondItem[1]));
            try {
                if (item1 == null || item2 == null) {
                    Log.getLogger().warn("Invalid crusher mode setting: " + string);
                    continue;
                }
                ItemStorage storage1 = new ItemStorage(new ItemStack((IItemProvider)item1, 2));
                ItemStorage storage2 = new ItemStorage(new ItemStack((IItemProvider)item2, 1));
                this.crusherModes.put(storage1, storage2);
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Error getting metaData", (Throwable)ex);
            }
        }
    }

    private static CompoundNBT writeLeafSaplingEntryToNBT(BlockState state, ItemStorage storage) {
        CompoundNBT compound = NBTUtil.func_190009_a((BlockState)state);
        storage.getItemStack().func_77955_b(compound);
        return compound;
    }

    private static Tuple<BlockState, ItemStorage> readLeafSaplingEntryFromNBT(CompoundNBT compound) {
        return new Tuple<BlockState, ItemStorage>(NBTUtil.func_190008_d((CompoundNBT)compound), new ItemStorage(ItemStack.func_199557_a((CompoundNBT)compound), false, true));
    }
}

