/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorage {
    private final ItemStack stack;
    private final boolean shouldIgnoreDamageValue;
    private final boolean shouldIgnoreNBTValue;
    private final List<Integer> creativeTabIndex;
    private int amount;

    public ItemStorage(@NotNull ItemStack stack, int amount, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = ignoreDamageValue;
        this.amount = amount;
        this.creativeTabIndex = stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue, boolean shouldIgnoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = shouldIgnoreNBTValue;
        this.amount = ItemStackUtils.getSize(stack);
        this.creativeTabIndex = stack.func_190926_b() ? new ArrayList<Integer>() : stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
        this.creativeTabIndex = stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public ItemStorage(@NotNull ItemStack stack) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = false;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
        this.creativeTabIndex = stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public static ItemStorage getItemStackOfListMatchingPredicate(List<ItemStorage> list, Predicate<ItemStack> predicate) {
        for (ItemStorage stack : list) {
            if (!predicate.test(stack.getItemStack())) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean ignoreDamageValue() {
        return this.shouldIgnoreDamageValue;
    }

    public List<Integer> getCreativeTabIndex() {
        return this.creativeTabIndex;
    }

    public int getPrimaryCreativeTabIndex() {
        return this.creativeTabIndex.isEmpty() ? 0 : this.creativeTabIndex.get(0);
    }

    public int hashCode() {
        return Objects.hash(this.stack.func_77973_b());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return this.stack.func_77969_a(that.getItemStack()) && (this.shouldIgnoreDamageValue || that.getDamageValue() == this.getDamageValue()) && (this.shouldIgnoreNBTValue || that.getItemStack().func_77978_p() == null && this.getItemStack().func_77978_p() == null || that.getItemStack().func_77978_p() != null && that.getItemStack().func_77978_p().equals((Object)this.getItemStack().func_77978_p()));
    }

    @NotNull
    public Item getItem() {
        return this.stack.func_77973_b();
    }

    public int getDamageValue() {
        return this.stack.func_77952_i();
    }
}

