/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class RecipeStorage
implements IRecipeStorage {
    @NotNull
    private final List<ItemStack> input;
    @NotNull
    private final List<ItemStorage> cleanedInput;
    @NotNull
    private final ItemStack primaryOutput;
    private final Block intermediate;
    private final int gridSize;
    private final IToken<?> token;

    public RecipeStorage(IToken<?> token, List<ItemStack> input, int gridSize, @NotNull ItemStack primaryOutput, Block intermediate) {
        this.input = Collections.unmodifiableList(input);
        this.cleanedInput = this.calculateCleanedInput();
        this.primaryOutput = primaryOutput;
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.token = token;
    }

    @Override
    public List<ItemStack> getInput() {
        return new ArrayList<ItemStack>(this.input);
    }

    @Override
    public List<ItemStorage> getCleanedInput() {
        return this.cleanedInput;
    }

    public List<ItemStorage> calculateCleanedInput() {
        ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
        for (ItemStack stack : this.input) {
            if (ItemStackUtils.isEmpty(stack).booleanValue() || stack.func_77973_b() == ModItems.buildTool) continue;
            ItemStorage storage = new ItemStorage(stack.func_77946_l());
            if (items.contains(storage)) {
                int index = items.indexOf(storage);
                ItemStorage tempStorage = (ItemStorage)items.remove(index);
                tempStorage.setAmount(tempStorage.getAmount() + storage.getAmount());
                storage = tempStorage;
            }
            items.add(storage);
        }
        return items;
    }

    @Override
    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.primaryOutput;
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    @Override
    public Block getIntermediate() {
        return this.intermediate;
    }

    @Override
    public boolean canFullFillRecipe(int qty, IItemHandler ... inventories) {
        int neededMultiplier = CraftingUtils.calculateMaxCraftingCount(qty, (IRecipeStorage)this);
        List<ItemStorage> items = this.getCleanedInput();
        for (ItemStorage stack : items) {
            ItemStack container;
            int neededCount;
            int availableCount = InventoryUtils.getItemCountInItemHandlers((Collection<IItemHandler>)ImmutableList.copyOf((Object[])inventories), itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack.getItemStack(), false, true));
            if (availableCount >= (neededCount = ItemStackUtils.isEmpty(container = stack.getItem().getContainerItem(stack.getItemStack())) != false || !ItemStackUtils.compareItemStacksIgnoreStackSize(stack.getItemStack(), container, false, true) ? stack.getAmount() * neededMultiplier : stack.getAmount())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecipeStorage)) {
            return false;
        }
        RecipeStorage that = (RecipeStorage)o;
        if (this.gridSize != that.gridSize || this.input.size() != that.input.size() || !ItemStackUtils.compareItemStacksIgnoreStackSize(this.primaryOutput, that.primaryOutput, false, true)) {
            return false;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            if (ItemStackUtils.compareItemStacksIgnoreStackSize(that.input.get(i), this.input.get(i), false, true) || that.input.get(i).func_190916_E() != this.input.get(i).func_190916_E()) continue;
            return false;
        }
        return this.intermediate == null ? that.intermediate == null : this.intermediate.equals(that.intermediate);
    }

    public int hashCode() {
        int result = this.input.hashCode();
        result = 31 * result + this.primaryOutput.hashCode();
        result = 31 * result + (this.intermediate != null ? this.intermediate.hashCode() : 0);
        result = 31 * result + this.gridSize;
        return result;
    }

    private boolean checkForFreeSpace(List<IItemHandler> handlers) {
        ArrayList<ItemStack> secondaryStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.input) {
            ItemStack container = stack.func_77973_b().getContainerItem(stack);
            if (ItemStackUtils.isEmpty(container).booleanValue()) continue;
            secondaryStacks.add(container);
        }
        secondaryStacks.add(this.getPrimaryOutput());
        if (secondaryStacks.size() > this.getInput().size()) {
            int freeSpace = 0;
            for (IItemHandler handler : handlers) {
                freeSpace += handler.getSlots() - InventoryUtils.getAmountOfStacksInItemHandler(handler);
            }
            return freeSpace >= secondaryStacks.size() - this.getInput().size();
        }
        return true;
    }

    @Override
    public boolean fullfillRecipe(List<IItemHandler> handlers) {
        ItemStorage stack;
        int amountNeeded;
        if (!this.checkForFreeSpace(handlers) || !this.canFullFillRecipe(1, handlers.toArray(new IItemHandler[0]))) {
            return false;
        }
        Iterator<ItemStorage> iterator = this.getCleanedInput().iterator();
        while (iterator.hasNext() && (amountNeeded = (stack = iterator.next()).getAmount()) != 0) {
            for (IItemHandler handler : handlers) {
                int slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack.getItemStack(), false, true));
                while (slotOfStack != -1 && amountNeeded > 0) {
                    int count = ItemStackUtils.getSize(handler.getStackInSlot(slotOfStack));
                    ItemStack extractedStack = handler.extractItem(slotOfStack, amountNeeded, false).func_77946_l();
                    if (ItemStackUtils.isEmpty(extractedStack).booleanValue()) {
                        handler.insertItem(slotOfStack, extractedStack, false);
                        return false;
                    }
                    if ((amountNeeded -= count) <= 0) continue;
                    slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack.getItemStack(), false, true));
                }
                if (amountNeeded > 0) continue;
                break;
            }
            if (amountNeeded <= 0) continue;
            return false;
        }
        this.insertCraftedItems(handlers);
        return true;
    }

    @Override
    public IToken<?> getToken() {
        return this.token;
    }

    private void insertCraftedItems(List<IItemHandler> handlers) {
        for (IItemHandler handler : handlers) {
            if (InventoryUtils.addItemStackToItemHandler(handler, this.getPrimaryOutput().func_77946_l())) break;
        }
        ArrayList<ItemStack> secondaryStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.input) {
            ItemStack container;
            if (stack.func_77973_b() == ModItems.buildTool || ItemStackUtils.isEmpty(container = stack.func_77973_b().getContainerItem(stack)).booleanValue()) continue;
            secondaryStacks.add(container);
        }
        for (ItemStack stack : secondaryStacks) {
            for (IItemHandler handler : handlers) {
                if (InventoryUtils.addItemStackToItemHandler(handler, stack.func_77946_l())) break;
            }
        }
    }
}

