/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.ldtteam.structurize.util.LanguageHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class VisibleCitizenStatus {
    private static Map<Integer, VisibleCitizenStatus> visibleStatusMap;
    private static int idCounter;
    public static final VisibleCitizenStatus EAT;
    public static final VisibleCitizenStatus HOUSE;
    public static final VisibleCitizenStatus RAIDED;
    public static final VisibleCitizenStatus MOURNING;
    public static final VisibleCitizenStatus BAD_WEATHER;
    public static final VisibleCitizenStatus SLEEP;
    public static final VisibleCitizenStatus SICK;
    public static final VisibleCitizenStatus WORKING;
    private final int id;
    private final ResourceLocation icon;
    private final String translationKey;

    public VisibleCitizenStatus(ResourceLocation icon, String translationKey) {
        this.icon = icon;
        this.translationKey = translationKey;
        if (visibleStatusMap == null) {
            visibleStatusMap = new HashMap<Integer, VisibleCitizenStatus>();
            idCounter = 1;
        }
        this.id = idCounter++;
        visibleStatusMap.put(this.id, this);
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getTranslatedText() {
        return LanguageHandler.translateKey((String)this.translationKey);
    }

    public int getId() {
        return this.id;
    }

    public static VisibleCitizenStatus getForId(int id) {
        return visibleStatusMap.get(id);
    }

    public static Map<Integer, VisibleCitizenStatus> getVisibleStatus() {
        return Collections.unmodifiableMap(visibleStatusMap);
    }

    static {
        idCounter = 1;
        EAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/hungry_2.png"), "com.minecolonies.gui.visiblestatus.eat");
        HOUSE = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/house_big.png"), "com.minecolonies.gui.visiblestatus.idle");
        RAIDED = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/raid_icon.png"), "com.minecolonies.gui.visiblestatus.raid");
        MOURNING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/mourning.png"), "com.minecolonies.gui.visiblestatus.mourn");
        BAD_WEATHER = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/bad_weather.png"), "com.minecolonies.gui.visiblestatus.rain");
        SLEEP = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/bed_icon.png"), "com.minecolonies.gui.visiblestatus.sleep");
        SICK = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/sick_icon.png"), "com.minecolonies.gui.visiblestatus.sick");
        WORKING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/working.png"), "com.minecolonies.gui.visiblestatus.working");
    }
}

