/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.entity.citizen.happiness.StaticHappinessModifier;
import com.minecolonies.api.util.Tuple;
import java.util.function.DoubleSupplier;
import net.minecraft.nbt.CompoundNBT;

public class TimeBasedHappinessModifier
extends StaticHappinessModifier {
    private final Tuple<Integer, Double>[] timeBasedFactor;
    private int days = 0;

    public TimeBasedHappinessModifier(String id, double weight, DoubleSupplier supplier, Tuple<Integer, Double>[] timeBasedFactor) {
        super(id, weight, supplier);
        this.timeBasedFactor = timeBasedFactor;
    }

    @Override
    public double getFactor() {
        double baseFactor;
        double factor = baseFactor = super.getFactor();
        if (baseFactor < 1.0) {
            for (Tuple<Integer, Double> tuple : this.timeBasedFactor) {
                if (this.days <= tuple.getA()) continue;
                factor = baseFactor * tuple.getB();
            }
        }
        return factor;
    }

    @Override
    public void reset() {
        this.days = 0;
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public void dayEnd() {
        super.dayEnd();
        if (this.getFactor() < 1.0) {
            ++this.days;
        } else {
            this.reset();
        }
    }

    @Override
    public void read(CompoundNBT compoundNBT) {
        super.read(compoundNBT);
        this.days = compoundNBT.func_74762_e("day");
    }

    @Override
    public void write(CompoundNBT compoundNBT) {
        super.write(compoundNBT);
        compoundNBT.func_74768_a("day", this.days);
    }
}

