/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCitizenInventory
extends Container {
    private final PlayerInventory playerInventory;
    private final int inventorySize;
    private String displayName;

    public ContainerCitizenInventory(int windowId, final PlayerInventory inv, PacketBuffer extra) {
        super(ModContainers.citizenInv, windowId);
        int i;
        BlockPos workBuilding;
        InventoryCitizen inventory;
        ICitizen data;
        final int colonyId = extra.func_150792_a();
        final int citizenId = extra.func_150792_a();
        this.playerInventory = inv;
        IColony colony = inv.field_70458_d.field_70170_p.field_72995_K ? IColonyManager.getInstance().getColonyView(colonyId, inv.field_70458_d.field_71093_bK.func_186068_a()) : IColonyManager.getInstance().getColonyByWorld(colonyId, inv.field_70458_d.field_70170_p);
        if (colony == null) {
            this.inventorySize = 0;
            return;
        }
        if (inv.field_70458_d.field_70170_p.field_72995_K) {
            data = ((IColonyView)colony).getCitizen(citizenId);
            inventory = data.getInventory();
            this.displayName = data.getName();
            workBuilding = data.getWorkBuilding();
        } else {
            data = citizenId > 0 ? colony.getCitizenManager().getCivilian(citizenId) : (ICitizenData)colony.getVisitorManager().getCivilian(citizenId);
            inventory = data.getInventory();
            this.displayName = data.getName();
            workBuilding = data.getWorkBuilding() == null ? null : data.getWorkBuilding().getID();
        }
        this.inventorySize = inventory.getSlots() / 9;
        int size = inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, index, 8 + k * 18, 18 + j * 18){

                    public void func_75215_d(@NotNull ItemStack stack) {
                        if (workBuilding != null && !((ContainerCitizenInventory)ContainerCitizenInventory.this).playerInventory.field_70458_d.field_70170_p.field_72995_K && !ItemStackUtils.isEmpty(stack).booleanValue()) {
                            IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, inv.field_70458_d.field_70170_p);
                            IBuilding building = colony.getBuildingManager().getBuilding(workBuilding);
                            ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId);
                            building.overruleNextOpenRequestOfCitizenWithStack(citizenData, stack);
                        }
                        super.func_75215_d(stack);
                    }
                });
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    @NotNull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.func_75211_c().func_77946_l();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.func_75135_a(stackCopy, maxIndex, this.field_75151_b.size(), true) : !this.func_75135_a(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.func_75215_d(ItemStackUtils.EMPTY);
        } else {
            slot.func_75215_d(stackCopy);
        }
        return stackCopy;
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return true;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

