/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import org.jetbrains.annotations.NotNull;

public class BlockStateStorage {
    private final BlockState state;
    private final List<IProperty<?>> propertyList;
    private int hashCode;
    private final boolean exclude;

    public BlockStateStorage(@NotNull BlockState state, @NotNull List<IProperty<?>> compareProperties, boolean exclude) {
        this.state = state;
        this.propertyList = compareProperties;
        this.exclude = exclude;
        this.hashCode = state.func_177230_c().hashCode();
        if (!exclude) {
            for (IProperty<?> prop : compareProperties) {
                if (!state.func_206869_a().contains(prop)) continue;
                this.hashCode += prop.hashCode();
                this.hashCode += state.func_177229_b(prop).hashCode();
            }
        } else {
            for (IProperty prop : state.func_206869_a()) {
                if (compareProperties.contains(prop)) continue;
                this.hashCode += prop.hashCode();
                this.hashCode += state.func_177229_b(prop).hashCode();
            }
        }
    }

    public BlockState getState() {
        return this.state;
    }

    public List<IProperty<?>> getCompareProperties() {
        return this.propertyList;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStateStorage comparingToStorage = (BlockStateStorage)o;
        if (comparingToStorage.getState() == this.state) {
            return true;
        }
        if (this.exclude) {
            for (IProperty prop : this.state.func_206869_a()) {
                if (this.getCompareProperties().contains(prop)) continue;
                if (!comparingToStorage.getState().func_206869_a().contains(prop)) {
                    return false;
                }
                if (comparingToStorage.getState().func_177229_b(prop).equals(this.state.func_177229_b(prop))) continue;
                return false;
            }
        } else {
            for (IProperty<?> prop : this.propertyList) {
                if (!comparingToStorage.getState().func_206869_a().contains(prop)) {
                    return false;
                }
                if (comparingToStorage.getState().func_177229_b(prop).equals(this.state.func_177229_b(prop))) continue;
                return false;
            }
        }
        return true;
    }
}

