/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Utils;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    private static final int AIR_SPACE_ABOVE_TO_CHECK = 2;
    private static final int DEFAULT_MOVE_RANGE = 3;
    private static final int TELEPORT_RANGE = 512;
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final int SCAN_RADIUS = 5;

    private EntityUtils() {
    }

    @NotNull
    public static PlayerEntity getPlayerOfFakePlayer(@NotNull PlayerEntity player, @NotNull World world) {
        PlayerEntity tempPlayer;
        if (player instanceof FakePlayer && (tempPlayer = world.func_217371_b(player.func_110124_au())) != null) {
            return tempPlayer;
        }
        return player;
    }

    public static Entity getPlayerByUUID(@NotNull World world, @NotNull UUID id) {
        return world.func_217371_b(id);
    }

    public static List<Entity> getEntitiesFromID(@NotNull World world, @NotNull List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((World)world).func_73045_a(arg_0)).collect(Collectors.toList());
    }

    public static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = MathHelper.func_76138_g((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    public static boolean checkForFreeSpace(@NotNull World world, @NotNull BlockPos groundPosition) {
        for (int i = 1; i < 2; ++i) {
            if (!EntityUtils.solidOrLiquid(world, groundPosition.func_177981_b(i)) && !world.func_180495_p(groundPosition.func_177981_b(i)).func_177230_c().func_203417_a(BlockTags.field_206952_E)) continue;
            return false;
        }
        return world.func_180495_p(groundPosition).func_185904_a().func_76220_a();
    }

    public static boolean solidOrLiquid(@NotNull World world, @NotNull BlockPos blockPos) {
        Material material = world.func_180495_p(blockPos).func_185904_a();
        return material.func_76220_a() || material.func_76224_d();
    }

    @Nullable
    public static BlockPos getSpawnPoint(World world, BlockPos nearPoint) {
        return Utils.scanForBlockNearPoint(world, nearPoint.func_177977_b(), 1, 2, 1, 2, Blocks.field_150350_a, Blocks.field_201941_jj, Blocks.field_150433_aE, Blocks.field_196804_gh);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull MobEntity living, int x, int y, int z) {
        return EntityUtils.tryMoveLivingToXYZ(living, x, y, z, 1.0);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull MobEntity living, int x, int y, int z, double speed) {
        return living.func_70661_as().func_75492_a((double)x, (double)y, (double)z, speed);
    }

    public static boolean isLivingAtSiteWithMove(@NotNull LivingEntity entity, int x, int y, int z) {
        return EntityUtils.isLivingAtSiteWithMove(entity, x, y, z, 3);
    }

    public static boolean isLivingAtSiteWithMove(@NotNull LivingEntity entity, int x, int y, int z, int range) {
        if (x == 0 && y == 0 && z == 0) {
            return false;
        }
        if (!EntityUtils.isLivingAtSite(entity, x, y, z, 512)) {
            BlockPos spawnPoint = Utils.scanForBlockNearPoint(entity.func_130014_f_(), new BlockPos(x, y, z), 5, 5, 5, 2, Blocks.field_150350_a, Blocks.field_201941_jj, Blocks.field_150433_aE, Blocks.field_196804_gh);
            if (spawnPoint == null) {
                spawnPoint = new BlockPos(x, y, z);
            }
            entity.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
            return true;
        }
        return EntityUtils.isLivingAtSite(entity, x, y, z, range);
    }

    public static boolean isEntityAtPosition(Entity entity, World world, Entity placer) {
        List<ItemStorage> existingReq = ItemStackUtils.getListOfStackForEntity(entity, placer);
        return world.func_217357_a(Entity.class, new AxisAlignedBB(entity.func_180425_c().func_177982_a(1, 1, 1), entity.func_180425_c().func_177982_a(-1, -1, -1))).stream().anyMatch(ent -> ent.field_70165_t == entity.field_70165_t && ent.field_70163_u == entity.field_70163_u && ent.field_70161_v == entity.field_70161_v && ItemStackUtils.getListOfStackForEntity(entity, placer).equals(existingReq));
    }

    public static boolean isEntityAtPosition(Entity entity, World world, AbstractEntityCitizen entityCitizen) {
        if (entity != null) {
            return EntityUtils.isEntityAtPosition(entity, world, (Entity)entityCitizen);
        }
        return false;
    }

    public static boolean isLivingAtSite(@NotNull LivingEntity entityLiving, int x, int y, int z, int range) {
        return entityLiving.func_180425_c().func_177951_i(new Vec3i(x, y, z)) < MathUtils.square(range);
    }

    public static boolean isFlying(LivingEntity target) {
        return target != null && (target.field_70160_al || !target.field_70122_E) && target.field_70143_R <= 0.1f && target.field_70170_p.func_175623_d(target.func_180425_c().func_177979_c(2));
    }
}

