/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.google.common.collect.Lists;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.BowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    public static final ItemStack EMPTY = ItemStack.field_190927_a;
    @NotNull
    public static final Predicate<ItemStack> EMPTY_PREDICATE = ItemStackUtils::isEmpty;
    @NotNull
    public static final Predicate<ItemStack> NOT_EMPTY_PREDICATE = EMPTY_PREDICATE.negate();
    private static final String NBT_TAG_ENCHANT_ID = "id";
    private static final String NBT_TAG_ENCHANT_LEVEL = "lvl";
    private static final int FORTUNE_ENCHANT_ID = 35;
    private static final int SILK_TOUCH_ENCHANT_ID = 33;
    public static Predicate<ItemStack> ISFOOD;
    public static Predicate<ItemStack> IS_SMELTABLE;
    public static Predicate<ItemStack> CAN_EAT;
    public static Predicate<ItemStack> ISCOOKABLE;
    public static final Predicate<ItemStack> IS_COMPOST;

    private ItemStackUtils() {
    }

    @Nullable
    public static Entity getEntityFromEntityInfoOrNull(CompoundNBT entityData, World world) {
        try {
            Entity entity;
            Optional type = EntityType.func_220347_a((CompoundNBT)entityData);
            if (type.isPresent() && (entity = ((EntityType)type.get()).func_200721_a(world)) != null) {
                entity.func_70020_e(entityData);
                return entity;
            }
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Couldn't restore entitiy", (Throwable)e);
            return null;
        }
        return null;
    }

    public static List<ItemStorage> getListOfStackForEntityInfo(CompoundNBT entityData, World world, Entity placer) {
        Entity entity;
        if (entityData != null && (entity = ItemStackUtils.getEntityFromEntityInfoOrNull(entityData, world)) != null) {
            if (EntityUtils.isEntityAtPosition(entity, world, placer)) {
                return Collections.emptyList();
            }
            return ItemStackUtils.getListOfStackForEntity(entity, placer);
        }
        return Collections.emptyList();
    }

    public static List<ItemStorage> getListOfStackForEntityInfo(CompoundNBT entityData, World world, AbstractEntityCitizen placer) {
        if (placer instanceof Entity) {
            return ItemStackUtils.getListOfStackForEntityInfo(entityData, world, (Entity)placer);
        }
        return Lists.newArrayList();
    }

    public static List<ItemStorage> getListOfStackForEntity(Entity entity, Entity placer) {
        if (entity != null) {
            ArrayList<ItemStorage> request = new ArrayList<ItemStorage>();
            if (entity instanceof ItemFrameEntity) {
                ItemStack stack2 = ((ItemFrameEntity)entity).func_82335_i();
                if (!ItemStackUtils.isEmpty(stack2).booleanValue()) {
                    ItemStackUtils.setSize(stack2, 1);
                    request.add(new ItemStorage(stack2));
                }
                request.add(new ItemStorage(new ItemStack((IItemProvider)Items.field_151160_bD, 1)));
            } else if (entity instanceof ArmorStandEntity) {
                request.add(new ItemStorage(entity.getPickedResult((RayTraceResult)new EntityRayTraceResult(placer))));
                entity.func_184193_aE().forEach(item -> request.add(new ItemStorage((ItemStack)item)));
                entity.func_184214_aD().forEach(item -> request.add(new ItemStorage((ItemStack)item)));
            }
            return request.stream().filter(stack -> !stack.getItemStack().func_190926_b()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean hasToolLevel(@Nullable ItemStack stack, IToolType toolType, int minimalLevel, int maximumLevel) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        int level = Compatibility.isTinkersWeapon(stack) ? Compatibility.getToolLevel(stack) : ItemStackUtils.getMiningLevel(stack, toolType);
        return ItemStackUtils.isTool(stack, toolType) && ItemStackUtils.verifyToolLevel(stack, level, minimalLevel, maximumLevel);
    }

    @NotNull
    public static Boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public static Boolean isNotEmpty(@Nullable ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false;
    }

    public static int getMiningLevel(@Nullable ItemStack stack, @Nullable IToolType toolType) {
        if (toolType == ToolType.NONE) {
            return stack == null ? 0 : 1;
        }
        if (!Compatibility.getMiningLevelCompatibility(stack, toolType.toString())) {
            return -1;
        }
        if (ToolType.HOE.equals(toolType)) {
            if (stack.func_77973_b() instanceof HoeItem) {
                HoeItem hoeItem = (HoeItem)stack.func_77973_b();
                return hoeItem.func_200891_e().func_200925_d();
            }
        } else if (ToolType.SWORD.equals(toolType)) {
            if (stack.func_77973_b() instanceof SwordItem) {
                SwordItem SwordItem2 = (SwordItem)stack.func_77973_b();
                return SwordItem2.func_200891_e().func_200925_d();
            }
            if (Compatibility.isTinkersWeapon(stack)) {
                return Compatibility.getToolLevel(stack);
            }
        } else if (ToolType.HELMET.equals(toolType) || ToolType.BOOTS.equals(toolType) || ToolType.CHESTPLATE.equals(toolType) || ToolType.LEGGINGS.equals(toolType)) {
            if (stack.func_77973_b() instanceof ArmorItem) {
                ArmorItem ArmorItem2 = (ArmorItem)stack.func_77973_b();
                return ItemStackUtils.getArmorLevel(ArmorItem2.func_200880_d());
            }
        } else {
            if (!toolType.hasVariableMaterials()) {
                return 1;
            }
            return stack.func_77973_b().getHarvestLevel(stack, net.minecraftforge.common.ToolType.get((String)toolType.getName()), null, null);
        }
        return -1;
    }

    public static boolean isTool(@Nullable ItemStack itemStack, IToolType toolType) {
        if (ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            return false;
        }
        boolean isATool = false;
        if (ToolType.AXE.equals(toolType) || ToolType.SHOVEL.equals(toolType) || ToolType.PICKAXE.equals(toolType)) {
            isATool = ItemStackUtils.getMiningLevel(itemStack, toolType) >= 0;
        } else if (ToolType.HOE.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof HoeItem;
        } else if (ToolType.BOW.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof BowItem;
        } else if (ToolType.SWORD.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof SwordItem || Compatibility.isTinkersWeapon(itemStack);
        } else if (ToolType.FISHINGROD.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof FishingRodItem;
        } else if (ToolType.SHEARS.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ShearsItem;
        } else if (ToolType.HELMET.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ArmorItem;
        } else if (ToolType.LEGGINGS.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ArmorItem;
        } else if (ToolType.CHESTPLATE.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ArmorItem;
        } else if (ToolType.BOOTS.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ArmorItem;
        } else if (ToolType.SHIELD.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ShieldItem;
        } else if (ToolType.FLINT_N_STEEL.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof FlintAndSteelItem;
        }
        return isATool;
    }

    public static boolean verifyToolLevel(@NotNull ItemStack itemStack, int toolLevel, int minimalLevel, int maximumLevel) {
        if (toolLevel < minimalLevel) {
            return false;
        }
        return toolLevel + ItemStackUtils.getMaxEnchantmentLevel(itemStack) <= maximumLevel;
    }

    public static boolean isDecoration(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151160_bD || item == Items.field_179565_cj || !Block.func_149634_a((Item)item).func_176223_P().func_185904_a().func_76220_a();
    }

    private static int getArmorLevel(IArmorMaterial material) {
        int damageReductionAmount = material.func_200902_b(EquipmentSlotType.CHEST);
        if (damageReductionAmount <= ArmorMaterial.LEATHER.func_200902_b(EquipmentSlotType.CHEST)) {
            return 0;
        }
        if (damageReductionAmount <= ArmorMaterial.GOLD.func_200902_b(EquipmentSlotType.CHEST) && material != ArmorMaterial.CHAIN) {
            return 1;
        }
        if (damageReductionAmount <= ArmorMaterial.CHAIN.func_200902_b(EquipmentSlotType.CHEST)) {
            return 2;
        }
        if (damageReductionAmount <= ArmorMaterial.IRON.func_200902_b(EquipmentSlotType.CHEST)) {
            return 3;
        }
        if (damageReductionAmount <= ArmorMaterial.DIAMOND.func_200902_b(EquipmentSlotType.CHEST)) {
            return 4;
        }
        return 5;
    }

    public static int getMaxEnchantmentLevel(ItemStack itemStack) {
        ListNBT ListNBT2;
        if (itemStack == null) {
            return 0;
        }
        short maxLevel = 0;
        if (itemStack != null && (ListNBT2 = itemStack.func_77986_q()) != null) {
            for (int j = 0; j < ListNBT2.size(); ++j) {
                short level = ListNBT2.func_150305_b(j).func_74765_d(NBT_TAG_ENCHANT_LEVEL);
                maxLevel = level > maxLevel ? level : maxLevel;
            }
        }
        return Math.max(maxLevel - 1, 0);
    }

    public static int getFortuneOf(@Nullable ItemStack tool) {
        if (tool == null) {
            return 0;
        }
        int fortune = 0;
        if (tool.func_77948_v()) {
            ListNBT t = tool.func_77986_q();
            for (int i = 0; i < t.size(); ++i) {
                short id = t.func_150305_b(i).func_74765_d(NBT_TAG_ENCHANT_ID);
                if (id != 35) continue;
                fortune = t.func_150305_b(i).func_74765_d(NBT_TAG_ENCHANT_LEVEL);
            }
        }
        return fortune;
    }

    public static boolean hasSilkTouch(@Nullable ItemStack tool) {
        if (tool == null) {
            return false;
        }
        boolean hasSilk = false;
        if (tool.func_77948_v()) {
            ListNBT t = tool.func_77986_q();
            for (int i = 0; i < t.size(); ++i) {
                short id = t.func_150305_b(i).func_74765_d(NBT_TAG_ENCHANT_ID);
                if (id != 33) continue;
                hasSilk = true;
            }
        }
        return hasSilk;
    }

    public static boolean doesItemServeAsWeapon(@NotNull ItemStack stack) {
        return stack.func_77973_b() instanceof SwordItem || stack.func_77973_b() instanceof ToolItem || Compatibility.isTinkersWeapon(stack);
    }

    public static String swapArmorGrade(int toolGrade) {
        switch (toolGrade) {
            case 0: {
                return "Leather";
            }
            case 1: {
                return "Gold";
            }
            case 2: {
                return "Chain";
            }
            case 3: {
                return "Iron";
            }
            case 4: {
                return "Diamond";
            }
        }
        return "Better than Diamond";
    }

    public static String swapToolGrade(int toolGrade) {
        switch (toolGrade) {
            case 0: {
                return "Wood or Gold";
            }
            case 1: {
                return "Stone";
            }
            case 2: {
                return "Iron";
            }
            case 3: {
                return "Diamond";
            }
        }
        return "Better than Diamond";
    }

    @NotNull
    public static Boolean areItemStacksMergable(ItemStack existingStack, ItemStack mergingStack) {
        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(existingStack, mergingStack).booleanValue()) {
            return false;
        }
        return existingStack.func_77976_d() >= ItemStackUtils.getSize(existingStack) + ItemStackUtils.getSize(mergingStack);
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    @NotNull
    public static int getSize(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.func_190916_E();
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        if (ItemStackUtils.isEmpty(itemStack1).booleanValue() && ItemStackUtils.isEmpty(itemStack2).booleanValue()) {
            return true;
        }
        if (!(ItemStackUtils.isEmpty(itemStack1).booleanValue() || ItemStackUtils.isEmpty(itemStack2).booleanValue() || itemStack1.func_77973_b() != itemStack2.func_77973_b() || itemStack1.func_77952_i() != itemStack2.func_77952_i() && matchDamage)) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.func_190916_E() > itemStack2.func_190916_E()) {
                return false;
            }
            if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                return ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2);
            }
            return !(itemStack1.func_77942_o() && !itemStack1.func_77978_p().isEmpty() || itemStack2.func_77942_o() && !itemStack2.func_77978_p().isEmpty());
        }
        return false;
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack) {
        return ItemStackUtils.compareItemStackListIgnoreStackSize(stacks, stack, true, true);
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack, boolean matchDamage, boolean matchNBT) {
        for (ItemStack tempStack : stacks) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(tempStack, stack, matchDamage, matchNBT)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static void setSize(@NotNull ItemStack stack, int size) {
        stack.func_190920_e(size);
    }

    public static void changeSize(@NotNull ItemStack stack, int amount) {
        stack.func_190920_e(stack.func_190916_E() + amount);
    }

    @NotNull
    public static ItemStack deserializeFromNBT(@NotNull CompoundNBT compound) {
        return ItemStack.func_199557_a((CompoundNBT)compound);
    }

    public static boolean isStackSapling(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        return stack.func_77973_b().func_206844_a(ItemTags.field_200037_g);
    }

    public static boolean hasSmeltableInFurnaceAndNoFuel(FurnaceTileEntity entity) {
        return ItemStackUtils.isEmpty(entity.func_70301_a(0)) == false && ItemStackUtils.isEmpty(entity.func_70301_a(1)) != false;
    }

    public static boolean hasNeitherFuelNorSmeltAble(FurnaceTileEntity entity) {
        return ItemStackUtils.isEmpty(entity.func_70301_a(0)) != false && ItemStackUtils.isEmpty(entity.func_70301_a(1)) != false;
    }

    public static boolean hasFuelInFurnaceAndNoSmeltable(FurnaceTileEntity entity) {
        return ItemStackUtils.isEmpty(entity.func_70301_a(0)) != false && ItemStackUtils.isEmpty(entity.func_70301_a(1)) == false;
    }

    static {
        IS_COMPOST = stack -> !stack.func_190926_b() && stack.func_77973_b() == ModItems.compost;
    }
}

