/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import org.jetbrains.annotations.NotNull;

public final class Pond {
    private static final int WATER_POOL_WIDTH_REQUIREMENT = 6;
    private static final int WATER_POOL_LENGTH_REQUIREMENT = 3;

    public static boolean checkWater(@NotNull IWorldReader world, @NotNull BlockPos water, WaterPathResult result) {
        if (Pond.checkWater(world, water, 6, 3)) {
            result.pond = water;
            return true;
        }
        return false;
    }

    public static boolean checkWater(@NotNull IWorldReader world, @NotNull BlockPos water, int width, int length) {
        int z;
        int y;
        if (world.func_180495_p(water).func_177230_c() != Blocks.field_150355_j || !world.func_175623_d(water.func_177984_a())) {
            return false;
        }
        int x = water.func_177958_n();
        return Pond.checkWaterPoolInDirectionXThenZ(world, x, y = water.func_177956_o(), z = water.func_177952_p(), 1, width, length) || Pond.checkWaterPoolInDirectionXThenZ(world, x, y, z, -1, width, length) || Pond.checkWaterPoolInDirectionZThenX(world, x, y, z, 1, width, length) || Pond.checkWaterPoolInDirectionZThenX(world, x, y, z, -1, width, length);
    }

    private static boolean checkWaterPoolInDirectionXThenZ(@NotNull IWorldReader world, int x, int y, int z, int vector, int width, int length) {
        for (int dx = x + width * vector; dx <= x + width * vector; ++dx) {
            if (world.func_180495_p(new BlockPos(dx, y, z)).func_177230_c() == Blocks.field_150355_j) continue;
            return false;
        }
        return Pond.checkWaterPoolInDirectionZ(world, x + length * vector, y, z, 1) && Pond.checkWaterPoolInDirectionZ(world, x + length * vector, y, z, -1);
    }

    private static boolean checkWaterPoolInDirectionZThenX(@NotNull IWorldReader world, int x, int y, int z, int vector, int width, int length) {
        for (int dz = z + width * vector; dz <= z + width * vector; ++dz) {
            if (world.func_180495_p(new BlockPos(x, y, dz)).func_177230_c() == Blocks.field_150355_j) continue;
            return false;
        }
        return Pond.checkWaterPoolInDirectionX(world, x, y, z + length * vector, 1) && Pond.checkWaterPoolInDirectionX(world, x, y, z + length * vector, -1);
    }

    private static boolean checkWaterPoolInDirectionZ(@NotNull IWorldReader world, int x, int y, int z, int vector) {
        for (int dz = z + 3 * vector; dz <= z + 3 * vector; ++dz) {
            if (world.func_180495_p(new BlockPos(x, y, dz)).func_177230_c() == Blocks.field_150355_j) continue;
            return false;
        }
        return true;
    }

    private static boolean checkWaterPoolInDirectionX(@NotNull IWorldReader world, int x, int y, int z, int vector) {
        for (int dx = x + 3 * vector; dx <= x + 3 * vector; ++dx) {
            if (world.func_180495_p(new BlockPos(dx, y, z)).func_177230_c() == Blocks.field_150355_j) continue;
            return false;
        }
        return true;
    }
}

