/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.api.util.Tuple;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SoundUtils {
    private static final int ONE_HUNDRED = 100;
    public static final double PITCH = 0.9;
    private static final Random rand = new Random();
    public static final double VOLUME = 0.5;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double PITCH_MULTIPLIER = 0.4;

    private SoundUtils() {
    }

    public static void playRandomSound(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull ICitizenData citizen) {
        double v = rand.nextDouble();
        if (v <= 0.1) {
            if (citizen.getSaturation() < 2.0) {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SATURATION_LOW, citizen);
            } else {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SATURATION_HIGH, citizen);
            }
        } else if (v <= 0.2) {
            if (citizen.getCitizenHappinessHandler().getHappiness() < 5.0) {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.UNHAPPY, citizen);
            } else {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.HAPPY, citizen);
            }
        } else if (v <= 0.3) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.GENERAL, citizen);
        } else if (v <= 0.4 && citizen.getEntity().isPresent() && citizen.getEntity().get().getCitizenDiseaseHandler().isSick()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SICKNESS, citizen);
        } else if (v <= 0.5 && (citizen.getHomeBuilding() == null || citizen.getHomeBuilding().getBuildingLevel() <= 2)) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.BAD_HOUSING, citizen);
        } else if (v <= 0.6 && worldIn.func_72896_J()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.BAD_WEATHER, citizen);
        } else if (v <= 1.0) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.NOISE, citizen);
        }
    }

    public static void playSoundAtCitizen(@NotNull World worldIn, @NotNull BlockPos position, @NotNull SoundEvent event) {
        worldIn.func_184133_a(null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
    }

    public static void playSoundAtCitizenWith(@NotNull World worldIn, @NotNull BlockPos position, @Nullable EventType type, @Nullable ICitizenData citizenData) {
        SoundEvent event;
        if (citizenData == null) {
            return;
        }
        if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().disableCitizenVoices.get()).booleanValue()) {
            return;
        }
        Map<EventType, Tuple<SoundEvent, SoundEvent>> map = citizenData.getJob() != null ? ModSoundEvents.SOUND_EVENTS.get(citizenData.getJob().getJobRegistryEntry().getRegistryName().func_110623_a()) : ModSoundEvents.SOUND_EVENTS.get(citizenData.isChild() ? "child" : "citizen");
        SoundEvent soundEvent = event = citizenData.isFemale() ? map.get((Object)type).getB() : map.get((Object)type).getA();
        if (type.getChance() > rand.nextDouble() * 100.0) {
            worldIn.func_184133_a(null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
        }
    }

    public static double getRandomPitch(Random random) {
        return 1.0 / (random.nextDouble() * 0.4 + 0.8);
    }
}

