/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import java.io.File;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    private Utils() {
    }

    @Nullable
    public static BlockPos scanForBlockNearPoint(@NotNull World world, @NotNull BlockPos point, int radiusX, int radiusY, int radiusZ, int height, Block ... blocks) {
        BlockPos closestCoords = null;
        double minDistance = Double.MAX_VALUE;
        for (int j = point.func_177956_o(); j <= point.func_177956_o() + radiusY; ++j) {
            for (int i = point.func_177958_n() - radiusX; i <= point.func_177958_n() + radiusX; ++i) {
                for (int k = point.func_177952_p() - radiusZ; k <= point.func_177952_p() + radiusZ; ++k) {
                    BlockPos tempCoords;
                    if (!Utils.checkHeight(world, i, j, k, height, blocks) || !world.func_180495_p((tempCoords = new BlockPos(i, j, k)).func_177977_b()).func_185904_a().func_76220_a() && !world.func_180495_p(tempCoords.func_177979_c(2)).func_185904_a().func_76220_a()) continue;
                    double distance = BlockPosUtil.getDistanceSquared(tempCoords, point);
                    if (closestCoords != null && !(distance < minDistance)) continue;
                    closestCoords = tempCoords;
                    minDistance = distance;
                }
            }
        }
        return closestCoords;
    }

    private static boolean checkHeight(@NotNull World world, int x, int y, int z, int height, Block ... blocks) {
        for (int dy = 0; dy < height; ++dy) {
            BlockState state = world.func_180495_p(new BlockPos(x, y + dy, z));
            if (Utils.arrayContains(blocks, state.func_177230_c()) || !state.func_185904_a().func_76230_c()) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayContains(@NotNull Object[] array, Object key) {
        for (Object o : array) {
            if (!Objects.equals(key, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockInRange(@NotNull World world, Block block, int posX, int posY, int posZ, int range) {
        for (int x = posX - range; x < posX + range; ++x) {
            for (int z = posZ - range; z < posZ + range; ++z) {
                for (int y = posY - range; y < posY + range; ++y) {
                    if (!Objects.equals(world.func_180495_p(new BlockPos(x, y, z)).func_177230_c(), block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean testFlag(int data, int flag) {
        return Utils.mask(data, flag) == flag;
    }

    public static int mask(int data, int mask) {
        return data & mask;
    }

    public static int setFlag(int data, int flag) {
        return data | flag;
    }

    public static int unsetFlag(int data, int flag) {
        return data & ~flag;
    }

    public static int toggleFlag(int data, int flag) {
        return data ^ flag;
    }

    public static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }
}

