/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod;

import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.configuration.Configuration;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.Log;
import com.minecolonies.apiimp.initializer.InteractionValidatorInitializer;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.render.EmptyTileEntitySpecialRenderer;
import com.minecolonies.coremod.client.render.FireArrowRenderer;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.client.render.RenderFishHook;
import com.minecolonies.coremod.client.render.RenderSitting;
import com.minecolonies.coremod.client.render.TileEntityColonyFlagRenderer;
import com.minecolonies.coremod.client.render.TileEntityEnchanterRenderer;
import com.minecolonies.coremod.client.render.TileEntityScarecrowRenderer;
import com.minecolonies.coremod.client.render.mobs.RenderMercenary;
import com.minecolonies.coremod.client.render.mobs.amazon.RendererAmazon;
import com.minecolonies.coremod.client.render.mobs.amazon.RendererChiefAmazon;
import com.minecolonies.coremod.client.render.mobs.barbarians.RendererBarbarian;
import com.minecolonies.coremod.client.render.mobs.barbarians.RendererChiefBarbarian;
import com.minecolonies.coremod.client.render.mobs.egyptians.RendererArcherMummy;
import com.minecolonies.coremod.client.render.mobs.egyptians.RendererMummy;
import com.minecolonies.coremod.client.render.mobs.egyptians.RendererPharao;
import com.minecolonies.coremod.client.render.mobs.norsemen.RendererArcherNorsemen;
import com.minecolonies.coremod.client.render.mobs.norsemen.RendererChiefNorsemen;
import com.minecolonies.coremod.client.render.mobs.norsemen.RendererShieldmaidenNorsemen;
import com.minecolonies.coremod.client.render.mobs.pirates.RendererArcherPirate;
import com.minecolonies.coremod.client.render.mobs.pirates.RendererChiefPirate;
import com.minecolonies.coremod.client.render.mobs.pirates.RendererPirate;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.colony.requestsystem.init.RequestSystemInitializer;
import com.minecolonies.coremod.colony.requestsystem.init.StandardFactoryControllerInitializer;
import com.minecolonies.coremod.event.ClientEventHandler;
import com.minecolonies.coremod.event.DebugRendererChunkBorder;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.event.FMLEventHandler;
import com.minecolonies.coremod.event.GatherDataHandler;
import com.minecolonies.coremod.event.HighlightManager;
import com.minecolonies.coremod.placementhandlers.PlacementHandlerInitializer;
import com.minecolonies.coremod.proxy.ClientProxy;
import com.minecolonies.coremod.proxy.CommonProxy;
import com.minecolonies.coremod.proxy.IProxy;
import com.minecolonies.coremod.proxy.ServerProxy;
import com.minecolonies.coremod.research.ResearchInitializer;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

@Mod(value="minecolonies")
public class MineColonies {
    @CapabilityInject(value=IColonyTagCapability.class)
    public static Capability<IColonyTagCapability> CLOSE_COLONY_CAP;
    @CapabilityInject(value=IChunkmanagerCapability.class)
    public static Capability<IChunkmanagerCapability> CHUNK_STORAGE_UPDATE_CAP;
    @CapabilityInject(value=IColonyManagerCapability.class)
    public static Capability<IColonyManagerCapability> COLONY_MANAGER_CAP;
    private static Configuration config;
    public static final IProxy proxy;

    public MineColonies() {
        LanguageHandler.loadLangPath((String)"assets/minecolonies/lang/%s.json");
        config = new Configuration();
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(EventHandler.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(FMLEventHandler.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ClientEventHandler.class));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(HighlightManager.class));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(DebugRendererChunkBorder.class));
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register(CommonProxy.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).addListener(GatherDataHandler::dataGeneratorSetup);
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register(this.getClass());
        InteractionValidatorInitializer.init();
        proxy.setupApi();
    }

    @SubscribeEvent
    public static void registerSounds(@NotNull RegistryEvent.Register<SoundEvent> event) {
        ModSoundEvents.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        event.addSprite(new ResourceLocation("minecolonies", "blocks/enchanting_table_book"));
        event.addSprite(new ResourceLocation("minecolonies", "blocks/blockscarecrownormal"));
        event.addSprite(new ResourceLocation("minecolonies", "blocks/blockscarecrowpumpkin"));
    }

    @SubscribeEvent
    public static void preInit(@NotNull FMLCommonSetupEvent event) {
        StructureLoadingUtils.addOriginMod((String)"minecolonies");
        CapabilityManager.INSTANCE.register(IColonyTagCapability.class, (Capability.IStorage)new IColonyTagCapability.Storage(), IColonyTagCapability.Impl::new);
        CapabilityManager.INSTANCE.register(IChunkmanagerCapability.class, (Capability.IStorage)new IChunkmanagerCapability.Storage(), IChunkmanagerCapability.Impl::new);
        CapabilityManager.INSTANCE.register(IColonyManagerCapability.class, (Capability.IStorage)new IColonyManagerCapability.Storage(), IColonyManagerCapability.Impl::new);
        Network.getNetwork().registerCommonMessages();
        AdvancementTriggers.preInit();
        StandardFactoryControllerInitializer.onPreInit();
        ResearchInitializer.fillResearchTree(MinecoloniesAPIProxy.getInstance().getGlobalResearchTree());
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        Log.getLogger().warn("FMLLoadCompleteEvent");
        PlacementHandlerInitializer.initHandlers();
        RequestSystemInitializer.onPostInit();
        MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().loadCost();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void doClientStuff(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CITIZEN, RenderBipedCitizen::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.VISITOR, RenderBipedCitizen::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.FISHHOOK, RenderFishHook::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.FIREARROW, FireArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BARBARIAN, RendererBarbarian::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARCHERBARBARIAN, RendererBarbarian::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CHIEFBARBARIAN, RendererChiefBarbarian::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.PIRATE, RendererPirate::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARCHERPIRATE, RendererArcherPirate::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CHIEFPIRATE, RendererChiefPirate::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.MUMMY, RendererMummy::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARCHERMUMMY, RendererArcherMummy::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.PHARAO, RendererPharao::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SHIELDMAIDEN, RendererShieldmaidenNorsemen::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.NORSEMEN_ARCHER, RendererArcherNorsemen::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.NORSEMEN_CHIEF, RendererChiefNorsemen::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.AMAZON, RendererAmazon::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.AMAZONCHIEF, RendererChiefAmazon::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.MERCENARY, RenderMercenary::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SITTINGENTITY, RenderSitting::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.MINECART, MinecartRenderer::new);
        ClientRegistry.bindTileEntityRenderer(MinecoloniesTileEntities.BUILDING, EmptyTileEntitySpecialRenderer::new);
        ClientRegistry.bindTileEntityRenderer(MinecoloniesTileEntities.SCARECROW, TileEntityScarecrowRenderer::new);
        ClientRegistry.bindTileEntityRenderer(MinecoloniesTileEntities.ENCHANTER, TileEntityEnchanterRenderer::new);
        ClientRegistry.bindTileEntityRenderer(MinecoloniesTileEntities.COLONY_FLAG, TileEntityColonyFlagRenderer::new);
        Arrays.stream(ModBlocks.getHuts()).forEach(hut -> RenderTypeLookup.setRenderLayer((Block)hut, renderType -> renderType.equals((Object)RenderType.func_228643_e_()) || renderType.equals((Object)RenderType.func_228639_c_())));
        RenderTypeLookup.setRenderLayer(ModBlocks.blockScarecrow, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer(ModBlocks.blockRack, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer(ModBlocks.blockDecorationPlaceholder, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer(ModBlocks.blockCompostedDirt, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer(ModBlocks.blockBarrel, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer(ModBlocks.blockBarracksTowerSubstitution, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer(ModBlocks.blockWayPoint, (RenderType)RenderType.func_228643_e_());
    }

    public static Configuration getConfig() {
        return config;
    }

    static {
        proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    }
}

