/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.views.View;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.client.gui.ViewFilterableList;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHutFilterableLists
extends AbstractWindowWorkerBuilding<AbstractFilterableListsView> {
    protected final Map<String, ViewFilterableList> views = new HashMap<String, ViewFilterableList>();
    protected Map<String, Predicate<ItemStack>> itemStackPredicate = new HashMap<String, Predicate<ItemStack>>();

    @SafeVarargs
    public AbstractHutFilterableLists(AbstractFilterableListsView building, String res, Tuple<String, Predicate<ItemStack>> ... predicates) {
        super(building, res);
        for (Tuple<String, Predicate<ItemStack>> tuple : predicates) {
            this.itemStackPredicate.put((String)tuple.func_76341_a(), (Predicate<ItemStack>)tuple.func_76340_b());
        }
    }

    public List<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate, String id) {
        if (!this.itemStackPredicate.containsKey(id)) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Collection)IColonyManager.getInstance().getCompatibilityManager().getBlockList().stream().filter(filterPredicate.and(this.itemStackPredicate.get(id))).map(ItemStorage::new).collect(Collectors.toList()));
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        for (Map.Entry<String, ViewFilterableList> view : this.views.entrySet()) {
            View parent = button.getParent();
            for (int maxDepth = 10; parent != null && maxDepth > 0; --maxDepth) {
                if ((parent = parent.getParent()) == null || !view.getKey().equals(parent.getID())) continue;
                view.getValue().onButtonClick(button);
                return;
            }
        }
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        for (ViewFilterableList view : this.views.values()) {
            view.onKeyTyped();
        }
        return result;
    }

    @Override
    public void onOpened() {
        super.onOpened();
        for (ViewFilterableList view : this.views.values()) {
            view.onOpened();
        }
    }
}

