/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.SwitchView;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.ClickGuiButtonTriggerMessage;
import com.minecolonies.coremod.network.messages.server.OpenGuiWindowTriggerMessage;
import java.util.HashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWindowSkeleton
extends Window
implements ButtonHandler {
    @NotNull
    private final HashMap<String, Consumer<Button>> buttons;
    protected final Label pageNum;
    protected final Button buttonPrevPage;
    protected final Button buttonNextPage;
    protected SwitchView switchView;
    private String resource;
    @Nullable
    private Window parent;

    public AbstractWindowSkeleton(String resource) {
        this(resource, null);
    }

    public AbstractWindowSkeleton(String resource, @Nullable Window parent) {
        super(resource);
        this.resource = resource;
        this.parent = parent;
        this.buttons = new HashMap();
        this.buttonNextPage = (Button)this.findPaneOfTypeByID("nextPage", Button.class);
        this.buttonPrevPage = (Button)this.findPaneOfTypeByID("prevPage", Button.class);
        this.pageNum = (Label)this.findPaneOfTypeByID("pageNum", Label.class);
        this.switchView = (SwitchView)this.findPaneOfTypeByID("pages", SwitchView.class);
        Network.getNetwork().sendToServer(new OpenGuiWindowTriggerMessage(this.resource));
    }

    public final void registerButton(String id, Runnable action) {
        this.registerButton(id, (Button button) -> action.run());
    }

    public final void registerButton(String id, Consumer<Button> action) {
        this.buttons.put(id, action);
    }

    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "prevPage": {
                this.setPage("prevPage");
                return;
            }
            case "nextPage": {
                this.setPage("nextPage");
                return;
            }
        }
        if (this.buttons.containsKey(button.getID())) {
            this.buttons.get(button.getID()).accept(button);
            Network.getNetwork().sendToServer(new ClickGuiButtonTriggerMessage(button.getID(), this.resource));
        }
    }

    public final void doNothing(Button ignored) {
    }

    public void setPage(@NotNull String button) {
        int switchPagesSize = this.switchView.getChildrenSize();
        int curPage = this.pageNum.getLabelText().isEmpty() ? 1 : Integer.parseInt(this.pageNum.getLabelText().substring(0, this.pageNum.getLabelText().indexOf("/")));
        switch (button) {
            case "prevPage": {
                this.switchView.previousView();
                --curPage;
                break;
            }
            case "nextPage": {
                this.switchView.nextView();
                ++curPage;
                break;
            }
            default: {
                if (switchPagesSize != 1) break;
                this.buttonPrevPage.off();
                this.buttonNextPage.off();
                this.pageNum.off();
                return;
            }
        }
        this.buttonNextPage.on();
        this.buttonPrevPage.on();
        if (curPage == 1) {
            this.buttonPrevPage.off();
        }
        if (curPage == switchPagesSize) {
            this.buttonNextPage.off();
        }
        this.pageNum.setLabelText(curPage + "/" + switchPagesSize);
    }

    public void close() {
        super.close();
        if (this.parent != null) {
            this.parent.open();
        }
    }
}

