/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowHireWorker;
import com.minecolonies.coremod.client.gui.WindowListRecipes;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.ChangeDeliveryPriorityMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.ForcePickupMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.OpenCraftingGUIMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.RecallCitizenMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowWorkerBuilding<B extends AbstractBuildingWorker.View>
extends AbstractWindowBuilding<B> {
    private static final String BUTTON_HIRE = "hire";
    private static final String LIST_WORKERS = "workers";
    private static final String BUTTON_RECALL = "recall";
    private static final String LABEL_PRIO_VALUE = "prioValue";
    private static final String LABEL_WORKERNAME = "workerName";
    private static final String LABEL_WORKERLEVEL = "workerLevel";
    private static final String BUILDER_HUT_NAME = "com.minecolonies.coremod.gui.workerhuts.buildersHut";
    private static final String BUTTON_CRAFTING = "crafting";
    private static final String BUTTON_RECIPES_LIST = "recipelist";
    private static final String BUTTON_DP_UP = "deliveryPrioUp";
    private static final String BUTTON_DP_DOWN = "deliveryPrioDown";
    private static final String BUTTON_FORCE_PICKUP = "forcePickup";
    private int prio;

    AbstractWindowWorkerBuilding(B building, String resource) {
        super(building, resource);
        this.prio = ((AbstractBuildingWorker.View)this.building).getBuildingDmPrio();
        super.registerButton(BUTTON_HIRE, this::hireClicked);
        super.registerButton(BUTTON_RECALL, this::recallClicked);
        super.registerButton(BUTTON_CRAFTING, this::craftingClicked);
        super.registerButton(BUTTON_RECIPES_LIST, this::recipeListClicked);
        super.registerButton(BUTTON_DP_UP, this::deliveryPrioUp);
        super.registerButton(BUTTON_DP_DOWN, this::deliveryPrioDown);
        super.registerButton(BUTTON_FORCE_PICKUP, this::forcePickup);
        ((ButtonImage)this.findPaneOfTypeByID(BUTTON_RECIPES_LIST, ButtonImage.class)).setVisible(((AbstractBuildingWorker.View)building).isRecipeAlterationAllowed() || !((AbstractBuildingWorker.View)building).getRecipes().isEmpty());
        ((ButtonImage)this.findPaneOfTypeByID(BUTTON_CRAFTING, ButtonImage.class)).setVisible(((AbstractBuildingWorker.View)building).isRecipeAlterationAllowed());
    }

    private void updatePriorityLabel() {
        if (this.prio == 0) {
            ((Label)this.findPaneOfTypeByID(LABEL_PRIO_VALUE, Label.class)).setLabelText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.buildPrio", (Object[])new Object[0]) + LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.deliveryprio.never", (Object[])new Object[0]));
        } else {
            ((Label)this.findPaneOfTypeByID(LABEL_PRIO_VALUE, Label.class)).setLabelText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.buildPrio", (Object[])new Object[0]) + this.prio + "/10");
        }
    }

    private void deliveryPrioUp() {
        if (this.prio != 10) {
            ++this.prio;
        }
        Network.getNetwork().sendToServer(new ChangeDeliveryPriorityMessage(this.building, true));
        this.updatePriorityLabel();
    }

    private void deliveryPrioDown() {
        if (this.prio != 0) {
            --this.prio;
        }
        Network.getNetwork().sendToServer(new ChangeDeliveryPriorityMessage(this.building, false));
        this.updatePriorityLabel();
    }

    private void forcePickup() {
        Network.getNetwork().sendToServer(new ForcePickupMessage(this.building));
    }

    private void recipeListClicked() {
        if (!((AbstractBuildingWorker.View)this.building).isRecipeAlterationAllowed() && ((AbstractBuildingWorker.View)this.building).getRecipes().isEmpty()) {
            return;
        }
        WindowListRecipes window = new WindowListRecipes(((AbstractBuildingWorker.View)this.building).getColony(), ((AbstractBuildingWorker.View)this.building).getPosition());
        window.open();
    }

    public void craftingClicked() {
        if (!((AbstractBuildingWorker.View)this.building).isRecipeAlterationAllowed()) {
            return;
        }
        BlockPos pos = ((AbstractBuildingWorker.View)this.building).getPosition();
        Minecraft.func_71410_x().field_71439_g.func_213829_a((INamedContainerProvider)Minecraft.func_71410_x().field_71441_e.func_175625_s(pos));
        Network.getNetwork().sendToServer(new OpenCraftingGUIMessage((AbstractBuildingView)this.building));
    }

    protected void hireClicked(@NotNull Button button) {
        if (((AbstractBuildingWorker.View)this.building).getBuildingLevel() == 0 && !BUILDER_HUT_NAME.equals(this.getBuildingName())) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"com.minecolonies.coremod.gui.workerhuts.level0", (Object[])new Object[0]);
            return;
        }
        WindowHireWorker window = new WindowHireWorker(((AbstractBuildingWorker.View)this.building).getColony(), ((AbstractBuildingWorker.View)this.building).getPosition());
        window.open();
    }

    private void recallClicked() {
        Network.getNetwork().sendToServer(new RecallCitizenMessage(this.building));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (this.findPaneByID(LIST_WORKERS) != null) {
            ScrollingList workerList = (ScrollingList)this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
            workerList.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return ((AbstractBuildingWorker.View)AbstractWindowWorkerBuilding.this.building).getWorkerId().size();
                }

                public void updateElement(int index, @NotNull Pane rowPane) {
                    ICitizenDataView worker;
                    if (!((AbstractBuildingWorker.View)AbstractWindowWorkerBuilding.this.building).getWorkerId().isEmpty() && (worker = ((AbstractBuildingWorker.View)AbstractWindowWorkerBuilding.this.building).getColony().getCitizen(((AbstractBuildingWorker.View)AbstractWindowWorkerBuilding.this.building).getWorkerId().get(index))) != null) {
                        ((Label)rowPane.findPaneOfTypeByID(AbstractWindowWorkerBuilding.LABEL_WORKERNAME, Label.class)).setLabelText(worker.getName());
                        ((Label)rowPane.findPaneOfTypeByID(AbstractWindowWorkerBuilding.LABEL_WORKERLEVEL, Label.class)).setLabelText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.workerLevel", (Object[])new Object[]{worker.getCitizenSkillHandler().getJobModifier(AbstractWindowWorkerBuilding.this.building)}));
                    }
                }
            });
        }
        this.updatePriorityLabel();
    }
}

